<?php

namespace App\Service;

//Inject the EM and Connection for the configured em that needs to be dynamic.
//I think you can actually just inject the EM, and call ->getConnection() it.
use App\Entity\Model\User;
use Doctrine\DBAL\DBALException;
use Doctrine\ORM\EntityManager;
use Doctrine\DBAL\Connection;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Core\Security;

//This service gets the dynamic DB creds from the request/user/whatever.
//use AppBundle\Services\RequestToAccount;

class EmFactory
{
    protected $security;
    protected $conn;
    protected $rawEm;
    protected $em = null;

    public function __construct(Security $security, Connection $connection, EntityManagerInterface $em)
    {
        $this->security = $security;
        $this->conn = $connection;
        $this->rawEm = $em;
    }

    public function getEm()
    {
        //This bit of code effectively caches the connection.
        //It assumes the connection isn't going to change once set during a request,
        //so it just returns the connected EM.
        if ($this->em !== null) {
            return $this->em;
        }
        //getDbCredArray() returns the DB creds as an array.
        //You can see the structure used below. This can be modified to suit.
        //$dbCreds = $this->reqToAcct->getDbCredArray();

        $user = $this->security->getUser();

        $dbParams = $this->conn->getParams();

        //This is an extra check to make sure the EM isn't already connected
        //to the correct DB. In my case, the user is always different.
        //You might check based on host, dbname, whatever.
        //$user = new User();
        if ($dbParams["dbname"] !== $user->getDataBase()) {

            //$dbParams["user"] = $dbCreds["user"];
            //$dbParams["host"] = $dbCreds["host"];
            $dbParams["dbname"] = $user->getDataBase();
            //$dbParams["password"] = $dbCreds["pass"];

            if ($this->conn->isConnected()) {
                $this->conn->close();
            }
            try {
                $this->conn->__construct(
                    $dbParams, $this->conn->getDriver(), $this->conn->getConfiguration(), $this->conn->getEventManager()
                );
            } catch (Doctrine\DBAL\DBALException $e) {
                throw new \Exception("Failed to connect to DB");
            }
            try {
                $this->conn->connect();
            } catch (\Exception $ex) {
                //Might want to log this error somewhere.
                throw new \Exception("Failed to connect to DB");
            }
        }
        $this->em = $this->rawEm;
        return $this->em;
    }

    public function getEmDefault()
    {
        //getDbCredArray() returns the DB creds as an array.
        //You can see the structure used below. This can be modified to suit.
        //$dbCreds = $this->reqToAcct->getDbCredArray();
        $dbParams = $this->conn->getParams();

        //This is an extra check to make sure the EM isn't already connected
        //to the correct DB. In my case, the user is always different.
        //You might check based on host, dbname, whatever.
        //$user = new User();
        //if ($dbParams["dbname"] !== $user->getDataBase()) {

            //$dbParams["user"] = $dbCreds["user"];
            //$dbParams["host"] = $dbCreds["host"];
            //$dbParams["dbname"] = $user->getDataBase();
            //$dbParams["password"] = $dbCreds["pass"];

            if ($this->conn->isConnected()) {
                $this->conn->close();
            }
            try {
                $this->conn->__construct(
                    $dbParams, $this->conn->getDriver(), $this->conn->getConfiguration(), $this->conn->getEventManager()
                );
            } catch (Doctrine\DBAL\DBALException $e) {
                throw new \Exception("Failed to connect to DB");
            }
            try {
                $this->conn->connect();
            } catch (\Exception $ex) {
                //Might want to log this error somewhere.
                throw new \Exception("Failed to connect to DB");
            }
        //}
        $this->em = $this->rawEm;
        return $this->em;
    }

    public function getEmDataBase(string $database)
    {
        //This bit of code effectively caches the connection.
        //It assumes the connection isn't going to change once set during a request,
        //so it just returns the connected EM.
        //if ($this->em !== null) {
        //    return $this->em;
        //}
        //getDbCredArray() returns the DB creds as an array.
        //You can see the structure used below. This can be modified to suit.
        //$dbCreds = $this->reqToAcct->getDbCredArray();

        $dbParams = $this->conn->getParams();

        //This is an extra check to make sure the EM isn't already connected
        //to the correct DB. In my case, the user is always different.
        //You might check based on host, dbname, whatever.
        //$user = new User();
        if ($dbParams["dbname"] !== $database) {

            //$dbParams["user"] = $dbCreds["user"];
            //$dbParams["host"] = $dbCreds["host"];
            $dbParams["dbname"] = $database;
            //$dbParams["password"] = $dbCreds["pass"];

            if ($this->conn->isConnected()) {
                $this->conn->close();
            }
            try {
                $this->conn->__construct(
                    $dbParams, $this->conn->getDriver(), $this->conn->getConfiguration(), $this->conn->getEventManager()
                );
            } catch (Doctrine\DBAL\DBALException $e) {
                throw new \Exception("Failed to connect to DB");
            }
            try {
                $this->conn->connect();
            } catch (\Exception $ex) {
                //Might want to log this error somewhere.
                throw new \Exception("Failed to connect to DB");
            }
        }
        $this->em = $this->rawEm;
        return $this->em;
    }

    //These are your factory methods.
    //They can be used to create services for repositories, so you can just inject
    //what you need directly into most services. Since it's just getting injected
    //in, those services don't know and don't care that the connection is dynamic.

    //Generic respository method.
    public function getRepository($repName)
    {
        return $this->getEm()->getRepository($repName);
    }

    //Specific repo method. I usually make one of these per repo that I plan to use.
    public function createThingRepository()
    {
        return $this->getEm()->getRepository('AppBundle:Thing');
    }

    public function getUser()
    {
        return $user = $this->security->getUser();
    }

}
