<?php

namespace App\Form;

use App\Entity\Model\PlacasSocios;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransporteSettingsType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $estransportista = $options['estransportista'];

        $builder->add('rucsocio', TextType::class, [
                'required' => true,
                'attr' => array('maxlength' => 13),
                'label' => 'RUC Personal Socio',
            ])
            ->add('nombresocio', TextType::class, [
                'required' => true,
                'attr' => array('maxlength' => 100),
                'label' => 'Socio Nombres',
            ])
            ->add('ptoemisionsocio', TextType::class, [
                'required' => true,
                'label' => 'Punto Emisión',
                'attr' => array('maxlength' => 3),
            ])
            ->add('tpcontribuyentesocio', ChoiceType::class, [
                'label' => 'Tipo Contribuyente',
                'required' => true,
                'choices' => array(
                    'GENERAL' => 'GENERAL',
                    'RIMPE' => 'RIMPE',
                ),
            ])

            ->add('estransportista', CheckboxType::class, [
                'required' => false,
                'label' => 'Transportista Socio',
                'data' => $estransportista
            ]);

        $newPlaca = new PlacasSocios();
        $builder->add('placas', CollectionType::class, array(
            'entry_type' => 'App\Form\PlacaType',
            'allow_add' => true,
            'allow_delete' => true,
            'prototype' => true,
            'by_reference' => false,
            'label' => false,
            'prototype_data' => $newPlaca,

        ));

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\TransporteSocio',
            'attr' => ['id' => 'transporte_settingssv'],
            'estransportista' => false,
        ]);
    }

}
