<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TaxType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'required' => false,
                'label' => 'tax.form.name',
                'attr' => ['class'=>'sv_uppercase'],
                'translation_domain' => 'core',
            ])
            ->add('value', NumberType::class, [
                'required' => false,
                'label' => 'tax.form.value',
                'attr' => ['class'=>'sv_uppercase'],
                'translation_domain' => 'core',
            ])
            ->add('active', CheckboxType::class, [
                'required' => false,
                'label' => 'tax.form.active',
                'translation_domain' => 'core',
            ])
            ->add('is_default', CheckboxType::class, [
                'required' => false,
                'label' => 'tax.form.is_default',
                'translation_domain' => 'core',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Tax::class,
        ]);
    }
}
