<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SeriesType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'required' => true,
                'label' => 'series.form.name',
                'attr' => ['class'=>'sv_uppercase'],
                'translation_domain' => 'core',
            ])
            ->add('value', TextType::class, [
                'required' => true,
                'label' => 'series.form.value',
                'attr' => ['class'=>'sv_uppercase'],
                'translation_domain' => 'core',
            ])
            ->add('iniFactura', NumberType::class, [
                'required' => true,
                'label' => 'series.form.ini_fa',
                'translation_domain' => 'core',
            ])
            ->add('iniCredito', NumberType::class, [
                'required' => true,
                'label' => 'series.form.ini_nc',
                'translation_domain' => 'core',
            ])
            ->add('iniRetencion', NumberType::class, [
                'required' => true,
                'label' => 'series.form.ini_re',
                'translation_domain' => 'core',
            ])
            ->add('iniGuia', NumberType::class, [
                'required' => true,
                'label' => 'series.form.ini_gr',
                'translation_domain' => 'core',
            ])
            ->add('iniDebito', NumberType::class, [
                'required' => true,
                'label' => 'series.form.ini_nd',
                'translation_domain' => 'core',
            ])
            ->add('iniLiquidacion', NumberType::class, [
                'required' => true,
                'label' => 'series.form.ini_lc',
                'translation_domain' => 'core',
            ])

            ->add('enabled', CheckboxType::class, [
                'label' => 'series.form.enabled',
                'translation_domain' => 'core',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Series::class,
        ]);
    }
}
