<?php

namespace App\Form;

use App\Entity\Model\Empresa;
use App\Entity\Model\Series;
use App\Entity\Model\Tax;
use App\Service\EmFactory;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use App\Entity\Model\Invoice;
use Symfony\Component\Security\Core\Security;

class SearchGenericAdminType extends AbstractType
{
    private $manager;

    private $security;

    private $empresa;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository(\App\Entity\Model\Empresa::class);
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());

        $builder
            ->add('terms', null, [
                'required' => false,
                'label' => 'search.terms',
                'translation_domain' => 'invoice',
            ])
            ->add('status', ChoiceType::class, [
                'label' => 'search.estado',
                'translation_domain' => 'invoice',
                'choices' => [
                    'search.autorizado' => 'autorizado',
                    'search.noautorizado' => 'rechazado'
                ],
                'required' => false,
            ])
            ->add('date_from', DateType::class, [
                'label' => 'search.date_from',
                'translation_domain' => 'invoice',
                'widget' => 'single_text',
                'required' => false,
            ])
            ->add('date_to', DateType::class, [
                'label' => 'search.date_to',
                'translation_domain' => 'invoice',
                'widget' => 'single_text',
                'required' => false,
            ])/*->add('customer', null, [
                'label' => 'search.customer',
                'translation_domain' => 'invoice',
                'required' => false,
            ])
            */
        ;

        /*$builder->add('series', EntityType::class, [
            'label' => 'search.series',
            'translation_domain' => 'invoice',
            'class' => 'App\Entity\Model\Series',
            'choice_label' => 'name',
            'required' => false,
        ]);
        */


        $builder->add('empresas', EntityType::class, [
            'class' => \App\Entity\Model\Empresa::class,
            'label' => 'Empresa',
            'choice_label' => static function (Empresa $value, $key, $index) {
                return $value->getRazonSocial();
            },'choice_value' => static function (Empresa $entity = null) {
                return $entity !== null ? $entity->getId() : '';
            }, 'query_builder' => static function (EntityRepository $er) {
                return $er->createQueryBuilder('t')
                    //->where('t.enabled = 1')
                    //->andWhere('t.empresa = :empresa_id')
                    //->setParameter('empresa_id', $this->empresa->getId());
                    ->orderBy('t.razonSocial');
            }, 'multiple' => false, 'required' => false]);


    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'csrf_protection' => false,
            'validation_groups' => false
        ]);

    }
}
