<?php

namespace App\Form\Admin;

use App\Entity\Model\Property;
use App\Service\EmFactory;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Form\Extension\Core\Type\FileType;

use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ParametroType extends AbstractType
{
    private $manager;
    private $security;
    private $empresa;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        /*$user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository('App\Entity\Model\Empresa');
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());
        */

        $newParametro = new Property();
        $builder
            ->add('parametros', CollectionType::class, array(
                //'label' => 'form.taxes',
                'entry_type' => 'App\Form\Admin\PropertyType',
                'allow_add' => true,
                'allow_delete' => true,
                'prototype' => true,
                'by_reference' => false,
                'label' => false,
                'entry_options' => ['label' => false],
                'prototype_data' => $newParametro,
                //'mapped' => false,
                //'data' => $options['data'],
            ))
            ->add('logoportada', FileType::class, [
                'required' => false,
                'label' => 'Logo Portada',
                'row_attr' => ['id' => 'demo'],

            ])
            ->add('detcuentatransfer', TextareaType::class, [
                'label' => 'Detalle',
                'attr' => ['rows' => 10, 'cols' => 80],
                'translation_domain' => 'core',
            ]);

        $builder->get('logoportada')
            ->addModelTransformer(new CallbackTransformer(
                function ($filename) {
                    return $filename ? new File($filename, false) : null;
                },
                function ($file) {
                    return $file;
                }
            ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {

    }
}
