<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 07/09/2017
 * Time: 18:01
 */

namespace App\Electronico;


use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Annotation\SerializedName;

class Pago
{
    /**
     * @Serializer\Type("string")
     * @SerializedName("formaPago")
     * @Serializer\XmlElement(cdata=false)
     */
    private $formaPago = '01';

    /**
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     */
    private $total;

    /**
     * @Serializer\Type("integer")
     */
    private  $plazo = 0;

    /**
     * @SerializedName("unidadTiempo")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $unidadTiempo = 'dias';

    public function __construct()
    {
    }

    /**
     * @return mixed
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }

    /**
     * @param mixed $formaPago
     */
    public function setFormaPago($formaPago)
    {
        $this->formaPago = $formaPago;
    }

    /**
     * @return mixed
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @param mixed $total
     */
    public function setTotal($total)
    {
        $this->total = number_format($total, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getPlazo()
    {
        return $this->plazo;
    }

    /**
     * @param mixed $plazo
     */
    public function setPlazo($plazo)
    {
        $this->plazo = $plazo;
    }

    /**
     * @param mixed $unidadTiempo
     */
    public function setUnidadTiempo($unidadTiempo)
    {
        $this->unidadTiempo = $unidadTiempo;
    }

    /**
     * @return mixed
     */
    public function getUnidadTiempo()
    {
        return $this->unidadTiempo;
    }


}

