<?php

namespace App\Electronico;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Annotation\SerializedName;

class InfoTributaria
{
    private $ambiente = 1;

    /**
     * @SerializedName("tipoEmision")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tipoEmision = 1;

    /**
     * @Serializer\Type("string")
     * @SerializedName("razonSocial")
     * @Serializer\XmlElement(cdata=false)
     */
    private $razonSocial;

    /**
     * @Serializer\Type("string")
     * @SerializedName("nombreComercial")
     * @Serializer\XmlElement(cdata=false)
     */
    private $nombreComercial;

    /**
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     */
    private $ruc;

    /**
     * @Serializer\Type("string")
     * @SerializedName("claveAcceso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $claveAcceso = "";

    /**
     * @SerializedName("codDoc")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codDoc;

    /**
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     */
    private $estab;

    /**
     * @Serializer\Type("string")
     * @SerializedName("ptoEmi")
     * @Serializer\XmlElement(cdata=false)
     */
    private $ptoEmi;

    /**
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     */
    private $secuencial;

    /**
     * @Serializer\Type("string")
     * @SerializedName("dirMatriz")
     * @Serializer\XmlElement(cdata=false)
     */
    private $dirMatriz;

    /**
     * @Serializer\Type("string")
     * @SerializedName("agenteRetencion")
     * @Serializer\XmlElement(cdata=false)
     */
    private $agenteRetencion;

    /**
     * @Serializer\Type("string")
     * @SerializedName("contribuyenteRimpe")
     * @Serializer\XmlElement(cdata=false)
     */
    private $contribuyenteRimpe;

    public function __construct()
    {
    }

    /**
     * @return mixed
     */
    public function getAmbiente()
    {
        return $this->ambiente;
    }

    /**
     * @param mixed $ambiente
     */
    public function setAmbiente($ambiente)
    {
        $this->ambiente = (int)$ambiente;
    }

    /**
     * @return mixed
     */
    public function getRazonSocial()
    {
        return $this->razonSocial;
    }

    /**
     * @param mixed $razonSocial
     */
    public function setRazonSocial($razonSocial)
    {
        $this->razonSocial = $razonSocial;
    }

    /**
     * @return mixed
     */
    public function getNombreComercial()
    {
        return $this->nombreComercial;
    }

    /**
     * @param mixed $nombreComercial
     */
    public function setNombreComercial($nombreComercial)
    {
        $this->nombreComercial = $nombreComercial;
    }

    /**
     * @return mixed
     */
    public function getRuc()
    {
        return $this->ruc;
    }

    /**
     * @param mixed $ruc
     */
    public function setRuc($ruc)
    {
        $this->ruc = $ruc;
    }

    /**
     * @return mixed
     */
    public function getClaveAcceso()
    {
        return $this->claveAcceso;
    }

    /**
     * @param mixed $claveAcceso
     */
    public function setClaveAcceso($claveAcceso)
    {
        $this->claveAcceso = $claveAcceso;
    }

    /**
     * @return mixed
     */
    public function getCodDoc()
    {
        return $this->codDoc;
    }

    /**
     * @param mixed $codDoc
     */
    public function setCodDoc($codDoc)
    {
        $this->codDoc = $codDoc;
    }

    /**
     * @return mixed
     */
    public function getEstab()
    {
        return $this->estab;
    }

    /**
     * @param mixed $estab
     */
    public function setEstab($estab)
    {
        $this->estab = $estab;
    }

    /**
     * @return mixed
     */
    public function getPtoEmi()
    {
        return $this->ptoEmi;
    }

    /**
     * @param mixed $ptoEmi
     */
    public function setPtoEmi($ptoEmi)
    {
        $this->ptoEmi = $ptoEmi;
    }

    /**
     * @return mixed
     */
    public function getSecuencial()
    {
        return $this->secuencial;
    }

    /**
     * @param mixed $secuencial
     */
    public function setSecuencial($secuencial)
    {
        $this->secuencial = $secuencial;
    }

    /**
     * @return mixed
     */
    public function getDirMatriz()
    {
        return $this->dirMatriz;
    }

    /**
     * @param mixed $dirMatriz
     */
    public function setDirMatriz($dirMatriz)
    {
        $this->dirMatriz = $dirMatriz;
    }

    /**
     * @return mixed
     */
    public function getAgenteRetencion()
    {
        return $this->agenteRetencion;
    }

    /**
     * @param mixed $agenteRetencion
     */
    public function setAgenteRetencion($agenteRetencion)
    {
        $this->agenteRetencion = $agenteRetencion;
    }

    /**
     * @return mixed
     */
    public function getContribuyenteRimpe()
    {
        return $this->contribuyenteRimpe;
    }

    /**
     * @param mixed $contribuyenteRimpe
     */
    public function setContribuyenteRimpe($contribuyenteRimpe)
    {
        $this->contribuyenteRimpe = $contribuyenteRimpe;
    }

}


