<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 2019-11-12
 * Time: 14:06
 */

namespace App\Util;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Reader\Csv as ReaderCsv;
use PhpOffice\PhpSpreadsheet\Reader\Ods as ReaderOds;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as ReaderXlsx;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;


class ExportInvoicePartnerExcel
{

    public function createSpreadsheet(array $invoices, $titulo, $desde, $hasta)
    {
        $spreadsheet = new Spreadsheet();
        // Get active sheet - also possible to retrieve a specific sheet
        $sheet = $spreadsheet->getActiveSheet();

        // Set cell name and merge cells
        $sheet->setCellValue('A1', $titulo)->mergeCells('A1:K1');
        try{
            if ($desde !== null) {
                $desde = $desde->format('d/M/Y');
                $sheet->setCellValue('A2', 'DESDE: '.$desde)->mergeCells('A2:C2');
            }
            if ($hasta !== null) {
                $hasta = $hasta->format('d/M/Y');
                $sheet->setCellValue('A3', 'HASTA: '.$hasta)->mergeCells('A3:C3');
            }
        }
        catch (\Exception $ex){

        }

        // Set column names
        $columnNames = [
            'FECHA',
            'SERIE',
            'NUMERO',
            'RUC',
            'CLIENTE',
            'BASE IVA',
            'BASE CERO',
            'IVA',
            'TOTAL',
            'AUTORIZADO',
            'CLAVE ACCESO',
            'FECHA_AUTORIZACION',
            'ANULADO'
        ];
        $columnLetter = 'A';
        foreach ($columnNames as $columnName) {
            // Allow to access AA column if needed and more
            $sheet->setCellValue($columnLetter . '5', $columnName);

            $sheet->getStyle($columnLetter . '1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle($columnLetter . '5')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
            // Text in bold
            $sheet->getStyle($columnLetter . '1')->getFont()->setBold(true);
            $sheet->getStyle($columnLetter . '5')->getFont()->setBold(true);
            // Autosize column
            $sheet->getColumnDimension($columnLetter)->setAutoSize(true);
            $columnLetter++;

        }

        // Add data for each column
        /*$columnValues = [
            ['Google Chrome', 'Google Inc.', 'September 2, 2008', 'C++'],
            ['Firefox', 'Mozilla Foundation', 'September 23, 2002', 'C++, JavaScript, C, HTML, Rust'],
            ['Microsoft Edge', 'Microsoft', 'July 29, 2015', 'C++'],
            ['Safari', 'Apple', 'January 7, 2003', 'C++, Objective-C'],
            ['Opera', 'Opera Software', '1994', 'C++'],
            ['Maxthon', 'Maxthon International Ltd', 'July 23, 2007', 'C++'],
            ['Flock', 'Flock Inc.', '2005', 'C++, XML, XBL, JavaScript'],
        ];
        */

        $i = 6; // Beginning row for active sheet
        foreach ($invoices as $key => $columnValue) {
            $columnLetter = 'A';
            foreach ($columnValue as $k => $value) {

                /*if( $k == 'ruc'  ) {
                    $sheet->setCellValueExplicit(
                        $columnLetter++ . $i, $v,
                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                }
                else if( $k == 'numero'  ) {
                    $sheet->setCellValueExplicit(
                        $columnLetter++ . $i, $v,
                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                }
                else if( $k == 'serie'  ) {
                    $sheet->setCellValueExplicit(
                        $columnLetter++ . $i, $v,
                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                }*/
                if( $k == 'ruc' ) {
                    $sheet->setCellValueExplicit($columnLetter++ . $i, $value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                }
                elseif( $k == 'serie' ) {
                    $sheet->setCellValueExplicit($columnLetter++ . $i, $value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                }
                elseif( $k == 'emision' ) {
                    $sheet->setCellValue($columnLetter++ . $i, $value->format('d/m/Y'));
                }
                elseif( $k == 'numero'  ) {
                    $sheet->setCellValueExplicit($columnLetter++ . $i, str_pad($value, 9, "0", STR_PAD_LEFT) ,  \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                }
                elseif($k == 'estado') {
                    $sheet->setCellValue($columnLetter++ . $i, $value == 'A' ? 'SI': 'NO');
                }
                else
                    $sheet->setCellValue($columnLetter++ . $i, $value);
            }
            $i++;
        }

        // Autosize each column and set style to column titles
        /*$columnLetter = 'A';
        foreach ($columnNames as $columnName) {
            // Center text
            $sheet->getStyle($columnLetter . '1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle($columnLetter . '2')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
            // Text in bold
            $sheet->getStyle($columnLetter . '1')->getFont()->setBold(true);
            $sheet->getStyle($columnLetter . '2')->getFont()->setBold(true);
            // Autosize column
            $sheet->getColumnDimension($columnLetter)->setAutoSize(true);
            $columnLetter++;



        }
        */

        return $spreadsheet;
    }

    protected function loadFile($filename)
    {
        return IOFactory::load($filename);
    }

    protected function readFile($filename)
    {
        $extension = pathinfo($filename, PATHINFO_EXTENSION);
        switch ($extension) {
            case 'ods':
                $reader = new ReaderOds();
                break;
            case 'xlsx':
                $reader = new ReaderXlsx();
                break;
            case 'csv':
                $reader = new ReaderCsv();
                break;
            default:
                throw new \Exception('Invalid extension');
        }
        $reader->setReadDataOnly(true);
        return $reader->load($filename);
    }

    protected function createDataFromSpreadsheet($spreadsheet)
    {
        $data = [];
        foreach ($spreadsheet->getWorksheetIterator() as $worksheet) {
            $worksheetTitle = $worksheet->getTitle();
            $data[$worksheetTitle] = [
                'columnNames' => [],
                'columnValues' => [],
            ];
            foreach ($worksheet->getRowIterator() as $row) {
                $rowIndex = $row->getRowIndex();
                if ($rowIndex > 2) {
                    $data[$worksheetTitle]['columnValues'][$rowIndex] = [];
                }
                $cellIterator = $row->getCellIterator();
                $cellIterator->setIterateOnlyExistingCells(false); // Loop all cells, even if it is not set
                foreach ($cellIterator as $cell) {
                    if ($rowIndex === 2) {
                        $data[$worksheetTitle]['columnNames'][] = $cell->getCalculatedValue();
                    }
                    if ($rowIndex > 2) {
                        $data[$worksheetTitle]['columnValues'][$rowIndex][] = $cell->getCalculatedValue();
                    }
                }
            }
        }

        return $data;
    }


}
