<?php


namespace App\Util;


use Exception;
use PDO;
use PDOException;

class DataAccess
{
    //Abrir conexion a la base de datos

    /*protected $log;
    protected $host = '127.0.0.1';
    protected $db = 'api_sharafac';
    protected $user = 'root';
    protected $pass = 'sirenaice';
    protected $charset = 'utf8mb4';
    */

    protected $log;

    protected $host = '127.0.0.1';

    protected $db = 'provsbdk_doc_sharafac';

    protected $user = 'root';

    protected $pass = 'sirenaice';

    protected $charset = 'utf8mb4';

    /**
     * DataAccess constructor.
     */
    public function __construct()
    {
        //$this->log = new \Shara\App\Log();

    }

    //Abrir conexion a la base de datos
    function connectPDO()
    {
        try {
            $conn = new PDO("mysql:host=127.0.0.1;dbname=grefa;charset=utf8", 'root', 'sirenaice');
            // set the PDO error mode to exception
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $conn;
        } catch (PDOException $pdoException) {
            //$this->log->setError("Connection PDO failed: " . $exception->getMessage());
            exit($pdoException->getMessage());
        }
    }

    protected function connect()
    {
        try {
            //$conn = new PDO("mysql:host=localhost;dbname=apisharafac;charset=utf8", "root", "sirenaice");

            # Para que genere excepciones a la hora de reportar errores.
            //$conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );

            //return $conn;

            // Create connection
            $conn = new mysqli("127.0.0.1", "root", "sirenaice", "api_sharafac",3306);

            // Check connection
            if ($conn->connect_error) {
                $this->log->setError("Connection failed: " . $conn->connect_error);
                die("Connection failed: " . $conn->connect_error);

            }

            $this->log->setInfo("base conectada connect");
            return $conn;

        } catch (Exception $exception) {
            $this->log->setError($exception->getMessage());
            exit($exception->getMessage());

        }
    }

    public function getEmisor(&$error, $ruc, $checkExiste = false)
    {

        $error = false;

        $conn = $this->connect();
        try {

            $sql = sprintf('SELECT *  FROM emisor WHERE ruc =\'%s\'', $ruc);
            $acentos = $conn->query(sprintf('SET NAMES \'%s\'', $this->charset));
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                $response = $result->fetch_assoc();
            } elseif ($checkExiste) {
                $response = null;
                $error = false;
            } else {
                $error = true;
                $response = ['error' => true, 'message' => "no se encontro datos para el numero de ruc, " . $ruc];
            }
        } catch (Exception $exception) {
            $error = true;
            $response = ['error' => true, 'message' => $exception->getMessage()];

        } finally {
            $conn->close();
        }

        return $response;
    }

    public function getComprobante($clave, $tabla)
    {

        $row = null;
        $conn = $this->connect();
        try {

            $sql = sprintf('SELECT *  FROM %s WHERE claveacceso =\'%s\'', $tabla, $clave);
            $result = $conn->query($sql);

            if ($result->num_rows == 1) {
                $row = $result->fetch_assoc();
            }
        } catch (Exception $exception) {
            $error = true;
            $this->log->setError($exception->getMessage());
        } finally {
            $conn->close();
        }

        return $row;
    }

    public function insertComprobante($sql)
    {

        $row = null;
        $conn = $this->connect();
        try {

            if ($conn->query($sql) === TRUE) {
                $response = ['error' => false, 'message' => "registro insertado, "];
            } else {
                $response = ['error' => true, 'message' => $conn->error];
            }
        } catch (Exception $exception) {
            $response = ['error' => true, 'message' => $exception->getMessage()];
        } finally {
            $conn->close();
        }

        return $response;
    }


    //Obtener parametros para updates
    public function getParams($input)
    {
        $filterParams = [];
        foreach ($input as $param => $value) {

            $filterParams[] = sprintf('%s=:%s', $param, $param);
        }

        return implode(", ", $filterParams);
    }

    public function getParamsUpdate($input)
    {
        $filterParams = [];
        foreach ($input as $param => $value) {

            $filterParams[] = sprintf('%s=:%s', $param, $param);
        }

        return implode(", ", $filterParams);
    }

    public function getParamsInsert($input, $values = false)
    {
        $filterParams = [];
        foreach ($input as $param => $value) {
            $filterParams[] = $values ? sprintf('%s', $param) : sprintf(':%s', $param);
        }

        return implode(", ", $filterParams);
    }

    //Asociar todos los parametros a un sql
    public function bindAllValues($statement, $params)
    {
        try {
            foreach ($params as $param => $value) {
                $statement->bindValue(':' . $param, $value);
            }

        } catch (\Exception $exception) {
            var_dump($exception);
        }

        return $statement;
    }

    public function execute($sql, $data)
    {
        $conn =null;
        $statement = null;
        try {

            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            $dsn = sprintf('mysql:host=%s;dbname=%s;charset=%s', $this->host, $this->db, $this->charset);

            $conn = new PDO($dsn, $this->user, $this->pass, $options);

            $statement = $conn->prepare($sql);
            $statement = $this->bindAllValues($statement, $data);

            $statement->execute();

            $response = ['error' => false, 'message' => "registro procesado, "];

        } catch (PDOException|Exception $e) {
            $response = ['error' => true, 'message' => $e->getMessage() . ", linea: " . $e->getCode()];
        } finally {
            $conn = null;
            $statement = null;
        }

        return $response;
    }


}
