<?php

namespace App\Repository;

use App\Entity\Model\PlacasSocios;
use App\Entity\Model\TransporteSocio;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\QueryBuilder;
use Knp\Component\Pager\PaginatorInterface;

/**
 * TransporteSocioRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class TransporteSocioRepository extends EntityRepository
{
    public $empresa_id;

    /**
     * @var mixed|\Knp\Component\Pager\PaginatorInterface
     */
    public $paginator;


    /**
     * There is no easy way to inject things into repositories yet.
     */
    public function setPaginator(PaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }

    public function paginatedSearch(array $params, $limit, $page, $empresa_id)
    {
        $this->empresa_id = $empresa_id;

        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->from(TransporteSocio::class, 'c')
            ->where('c.empresa = :empresa')
            ->setParameter('empresa', $empresa_id);

        $this->addPaginatedSearchSelects($qb);
        $this->applySearchParamsToQuery($params, $qb);

        return $this->paginator->paginate($qb->getQuery(), $page, $limit, [
            'defaultSortFieldName' => 'c.id',
            'defaultSortDirection' => 'desc',
        ]);
    }

    protected function applySearchParamsToQuery(array $params, QueryBuilder $qb)
    {
        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }

            if ($field == 'terms') {
                $aux = $qb->expr()->literal(sprintf('%%%s%%', $value));
                $qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('c.rucsocio', $aux),
                    $qb->expr()->like('c.nombresocio',$aux),
                    $qb->expr()->like('c.ptoemisionsocio',$aux)
                ));
            }
        }
    }

    protected function addPaginatedSearchSelects(QueryBuilder $qb)
    {
        // Select everything by default.
        $qb->select('c');
    }

    public function findIdentificacion($term, $empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(TransporteSocio::class, 'c')
            ->Where('c.rucsocio = :name')
            ->andWhere('c.empresa = :empresa')
            ->setParameter('name',  $term )
            ->setParameter('empresa',  $empresa_id )
            ->getQuery()
            ->getResult();
    }

    public function findPtoEmision($pto, $empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(TransporteSocio::class, 'c')
            ->andWhere('c.empresa = :empresa')
            ->andWhere('c.ptoemisionsocio = :pto')
            ->setParameter('empresa',  $empresa_id )
            ->setParameter('pto',  $pto )
            ->getQuery()
            ->getResult();
    }

    public function findPlacasSocioEmpresa($socio_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(PlacasSocios::class, 'c')
            ->where('c.transportesocio = :socio_id')
            ->setParameter('socio_id', $socio_id)
            ->getQuery()
            ->getResult();
    }

    public function findBySlug(string $slug, $id): ? TransporteSocio
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(TransporteSocio::class, 'c')
                ->Where("c.slug = :slug")
                ->andWhere("c.id = :id")
                ->setParameter('slug', $slug)
                ->setParameter('id', $id)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $nonUniqueResultException) {
            return null;
        }
    }
}
