<?php

namespace App\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\QueryBuilder;

use Knp\Component\Pager\PaginatorInterface;
use App\Entity\Model\TipoRetencion;

/**
 * InvoiceRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class TipoRetencionRepository extends EntityRepository
{
    /**
     * @var mixed|\Knp\Component\Pager\PaginatorInterface
     */
    public $paginator;

    public function findCodigo($codigo)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(TipoRetencion::class, 'c')
            ->Where('c.codigo = :cod')
            ->setParameter('cod',  $codigo )
            ->getQuery()
            ->getOneOrNullResult();
    }

    public function paginatedSearch(array $params, $limit = 50, $page = 1)
    {
        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->from($this->getEntityName(), 'i');
        //->Where('i.ambiente is null')
        $this->addPaginatedSearchSelects($qb);
        $this->applySearchParamsToQuery($params, $qb);

        return $this->paginator->paginate($qb->getQuery(), $page, $limit, [
            'defaultSortFieldName' => 'i.codigo',
            'defaultSortDirection' => 'desc',
        ]);
    }

    /**
     * There is no easy way to inject things into repositories yet.
     */
    public function setPaginator(PaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }


    protected function applySearchParamsToQuery(array $params, QueryBuilder $qb)
    {
        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }

            if ($field == 'usuario' ) {
                $qb->andWhere('i.usuario = :usuario');
                $qb->setParameter('usuario', $value);

            }

            if ($field == 'terms') {
                $qb->join('i.series', 's');
                $terms = $qb->expr()->literal(sprintf('%%%s%%', $value));
                if ($this->getEntityName() == TipoRetencion::class) {
                    $expr = $qb->expr()->orX(
                        $qb->expr()->like('i.number', $terms),
                        $qb->expr()->like('s.name', $terms),
                        $qb->expr()->like("CONCAT(s.value, i.number)", $terms)
                    );
                } else {
                    $expr = $qb->expr()->like('s.name', $terms);
                }

                $qb->andWhere($expr);

            }elseif ($field == 'autorizado') {
                if($value === 'anulada')
                    $qb->andWhere('i.anulado = true');
                elseif($value === 'sinresp')
                    $qb->andWhere('i.sinrespuesta = true');
                else {
                    $qb->andWhere('i.anulado = false');
                    $qb->andWhere('i.sinrespuesta = false');
                    $qb->andWhere('i.autorizado = :auto');
                    if ($value === 'autosi')
                        $qb->setParameter('auto', true);
                    else
                        $qb->setParameter('auto', false);
                }
            }
            elseif ($field == 'date_from') {
                $qb->andWhere('i.issue_date >= :date_from');
                $qb->setParameter('date_from', $value);
            } elseif ($field == 'date_to') {
                $qb->andWhere('i.issue_date <= :date_to');
                $qb->setParameter('date_to', $value);
            } elseif ($field == 'status') {
                $qb->andWhere('i.status = :status');
                $qb->setParameter('status', $value);
            } elseif ($field == 'customer') {
                //$qb->join('i.customer', 'c');
                //$qb->andWhere('i.customer = :estudiante');
                //$qb->setParameter('estudiante', $value);

                $customer = $qb->expr()->literal(sprintf('%%%s%%', $value));
                $qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('i.customer_name', $customer)
                ));

            } elseif ($field == 'series') {
                $qb->andWhere('i.series = :series');
                $qb->setParameter('series', $value);
            } elseif ($field == 'tax') {
                $qb->join('i.items', 'it');
                $qb->join('it.taxes', 'tx');
                $qb->andWhere('tx.id = :tax');
                $qb->setParameter('tax', $value);
            }
        }
    }

    protected function addPaginatedSearchSelects(QueryBuilder $qb)
    {
        // Select everything by default.
        $qb->select('i');
    }
}
