<?php

namespace App\Repository;

use App\Entity\Model\FormaPago;
use Doctrine\ORM\EntityRepository;
use App\Entity\Model\Empresa;
use App\Entity\Model\Property;
use App\Entity\Model\Series;
use App\Entity\Model\Tax;
use Doctrine\ORM\NonUniqueResultException;

/**
 * PropertyRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PropertyRepository extends EntityRepository
{
    /**
     * Shorthand to get a Property value with optional default value
     *
     * @return mixed
     *
     **/
    public function get($key, $value = null)
    {
        if ($property = $this->findOneBy(array('key' => $key))) {
            $value = $property->getValue();
        }

        return $value;
    }

    /**
     * Shorthand to get a Property value with optional default value
     *
     * @return mixed
     *
     **/
    public function getKey($name)
    {
        if ($property = $this->findOneBy(array('name' => $name))) {
            $value = $property->getKey();
        }

        return $value;
    }

    /**
     * Shorthand to get a Property value with optional default value
     *
     * @return mixed
     *
     **/
    public function getValue($name)
    {
        if ($property = $this->findOneBy(array('name' => $name))) {
            $value = $property->getValue();
        }

        return $value;
    }

    /**
     * Shorthand to create or update a Property
     *
     * @return Property
     *
     **/
    public function setProperty($key, $value = null)
    {
        if (!$property = $this->findOneBy(array('key' => $key))) {
            $property = new Property();
            $property->setKey($key);
        }

        $property->setValue($value);

        return $property;
    }

    /**
     * Returns an associative array with all the properties
     *
     * @return array
     *
     **/
    public function getAll()
    {
        $result = array();
        foreach ($this->findAll() as $property) {
            $result[$property->getKey()] = $property->getValue();
        }

        return $result;
    }

    public function findFormaPagoByCodigo($term): ?FormaPago
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(FormaPago::class, 'c')
                ->Where('c.codigo = :name')
                //->andWhere('c.empresa = :empresa')
                ->setParameter('name', $term)
                //->setParameter('empresa', $empresa_id)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

}
