<?php

namespace App\Repository;

use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\Tools\Pagination\Paginator;
use Knp\Component\Pager\PaginatorInterface;
use App\Entity\Model\Invoice;
use App\Entity\Model\Product;

/**
 * ProductRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ProductRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * @var mixed|\Knp\Component\Pager\PaginatorInterface
     */
    public $paginator;

    public function findBySlug(string $slug, $id): ?Product
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Product::class, 'c')
                ->Where("c.slug = :slug")
                ->andWhere("c.id = :id")
                ->setParameter('slug', $slug)
                ->setParameter('id', $id)
                ->setParameter('slug', $slug)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $nonUniqueResultException) {
            return null;
        }
    }

    public function findLikeReference(string $term, $empresa_id): array
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('p')
            ->from(Product::class, 'p')
            ->where('p.reference LIKE :term')
            ->andwhere('p.empresa = :empresa_id')
            ->setParameter('term', '%'. $term .'%')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public function findLikeDescripcion(string $term, $empresa_id): array
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('p')
            ->from(Product::class, 'p')
            ->where('p.description LIKE :term')
            ->andwhere('p.empresa = :empresa_id')
            ->setParameter('term', '%'. $term .'%')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public function paginatedSearch(array $params, $limit, $page, $empresa_id)
    {
        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('p')
            ->from(Product::class, 'p')
            ->where('p.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id);

        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }

            if ($field == 'terms') {
                $terms = $qb->expr()->literal(sprintf('%%%s%%', $value));
                $qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('p.reference', $terms),
                    $qb->expr()->like('p.description', $terms)
                ));
            }
        }

        $qb->leftJoin('p.items', 'i');
        $qb->leftJoin('i.invoice', 'ii', 'WITH', 'ii.status <> ?1')
            ->setParameter(1, Invoice::DRAFT);
        $qb->addSelect('SUM(CASE WHEN i.unitary_cost IS NULL OR ii.id IS NULL THEN 0 ELSE i.unitary_cost END * CASE WHEN i.quantity IS NULL THEN 0 ELSE i.quantity END) AS revenue');
        $qb->addSelect('SUM(CASE WHEN i.quantity IS NULL OR ii.id IS NULL THEN 0 ELSE i.quantity END) AS num_sold');
        $qb->groupBy('p.id');

        return $this->paginator->paginate($qb->getQuery(), $page, $limit);
    }

    /**
     * There is no easy way to inject things into repositories yet.
     */
    public function setPaginator(PaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }

    public function paginatedAjaxVentas(string $sql, $params, $limit, $page, $empresa_id)
    {
        $query = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('p')
            ->from(Product::class, 'p')
            ->where('p.empresa = :empresa_id')
            //->orWhere("p.clase = 'SER'")
            //->andWhere('p.stock > 0')
            //->andWhere('p.disponibleventa = true')
            ->setParameter('empresa_id', $empresa_id)
            ->setFirstResult($page)
            ->setMaxResults($limit)
            ->orderBy('p.description');

       /* $expr = $query->expr()->orX(
            $query->expr()->gt('p.stock','0'),
            $query->expr()->eq('p.clase',"'SER'")
        );

        $query->andWhere($expr);
       */

        if ($params) {
            $terms = $query->expr()->literal(sprintf('%%%s%%', $params));
            $query->andWhere($query->expr()->orX(
                $query->expr()->like('p.reference', $terms),
                $query->expr()->like('p.description', $terms)
            ));
        }

        return  new Paginator($query, $fetchJoinCollection = true);

    }

}
