<?php

namespace App\Repository;

use App\Entity\Model\PagoEmpresa;
use Doctrine\ORM\NonUniqueResultException;
use Knp\Component\Pager\PaginatorInterface;

/**
 * CustomerRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PagoEmpresaRepository extends \Doctrine\ORM\EntityRepository
{

    public function findById(string $id) : ?PagoEmpresa
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(PagoEmpresa::class, 'c')
                ->Where("c.id = :id")
                ->setParameter('id', $id)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

    public function findBySlug(string $slug, $id): ?PagoEmpresa
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(PagoEmpresa::class, 'c')
                ->Where("c.slug = :slug")
                ->andWhere("c.id = :id")
                ->setParameter('slug', $slug)
                ->setParameter('id', $id)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

    public function findLike($term, $empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(PagoEmpresa::class, 'c')
            ->where('c.name LIKE :name')
            ->andWhere('c.empresa = :empresa_id')
            ->orWhere('c.identification LIKE :name')
            ->setParameter('name', '%' . $term . '%')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public function paginatedSearch(array $params, $limit = 50, $page = 1)
    {
        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(PagoEmpresa::class, 'c');

        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }
            if ($field == 'terms') {
                $terms = $qb->expr()->literal("%$value%");
                $qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('c.numerocomprobante', $terms)
                //$qb->expr()->like('c.name', $terms)
                ));
            } elseif ($field == 'date_from') {
                $qb->andWhere('c.create_date >= :date_from');
                $qb->setParameter('date_from', $value);
            } elseif ($field == 'date_to') {
                $qb->andWhere('c.create_date <= :date_to');
                $qb->setParameter('date_to', $value);
            } elseif ($field == 'status') {
                $qb->andWhere('c.cerrado = :status');
                $qb->setParameter('status', $value);
            } elseif ($field == 'empresas') {
                $qb->andWhere('c.empresa = :empresa');
                $qb->setParameter('empresa', $value);

            }
        }

        $qb->orderBy('c.create_date', 'desc');

        return $this->paginator->paginate($qb->getQuery(), $page, $limit);

    }

    /**
     * There is no easy way to inject things into repositories yet.
     */
    public
    function setPaginator(PaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }

    public
    function findIdentificacion($term, $empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(PagoEmpresa::class, 'c')
            ->Where('c.identification = :name')
            ->andWhere('c.empresa = :empresa')
            ->setParameter('name', $term)
            ->setParameter('empresa', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public
    function findNumeroComprobante($empresa_id, $numero)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c.id')
            ->from(PagoEmpresa::class, 'c')
            ->Where("c.numerocomprobante = :numero")
            ->andWhere('c.empresa = :empresa')
            ->setParameter('empresa', $empresa_id)
            ->setParameter('numero', $numero)
            ->getQuery()
            ->getResult();

    }
}
