<?php

namespace App\Form;


use App\Entity\Model\Empresa;
use App\Entity\Model\ItemInvoiceReembolso;
use App\Entity\Model\Tax;
use App\Entity\Model\TipoDocReembolso;
use App\Service\EmFactory;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ItemInvoiceReembolsoType extends AbstractType
{

    private $manager;

    private $security;

    private $empresa;


    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository(Empresa::class);
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());

        $builder
            ->add('provreembolso_name', null, [
                'required' => true,
                'label' => 'Proveedor',
            ])
            ->add('provreembolso_identification', null, [
                'required' => true,
                'attr' => ['autocomplete' => 'on'],
                'label' => 'Identificación',
            ])
            ->add('tipodocreembolso', EntityType::class, [
                'class' => TipoDocReembolso::class,
                'label' => 'Doc. Sustento',
                'choice_label' => static function (TipoDocReembolso $item, $key, $index) {
                    return str_pad($item->getCodigo(), 2, "0", STR_PAD_LEFT) . ' - ' . $item->getName();
                },
                'choice_value' => static function (TipoDocReembolso $entity = null) {
                    return $entity !== null ? $entity->getId() : '';
                },
                'query_builder' => static function (EntityRepository $er) {
                    return $er->createQueryBuilder('t')
                        ->where('t.enabled = 1');
                },
                'multiple' => false,
                'required' => true
            ])
            ->add('serieDocumento', null, [
                'required' => true,
                'attr' => ['readonly' => false, 'maxlength' => 6, 'minlength' => 6, 'class' => 'intTextBox'],
                'label' => 'Serie',
            ])
            ->add('secuencialDoc', null, [
                'required' => true,
                'attr' => ['readonly' => false, 'maxlength' => 9, 'class' => 'intTextBox'],
                'label' => 'Número',
            ])
            ->add('emisionDocumento', DateType::class, [
                'widget' => 'single_text',
                'label' => 'Emisión',
            ])
            ->add('autoDocumento', null, [
                'required' => true,
                'attr' => ['readonly' => false, 'maxlength' => 49, 'minlength' => 10, 'class' => 'intTextBox'],
                'label' => 'Autorización',
            ])
            ->add('imponible', NumberType::class, [
                'scale' => 2,
                'grouping' => true,
                'required' => true,
                'attr' => ['class' => 'svtext-right', 'onkeypress' => "return filterFloat(event,this)"]
            ])
            ->add('taxes', EntityType::class, [
                'class' => Tax::class,
                'choice_label' => static function (Tax $value, $key, $index) {
                    return $value->getName();
                },
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('t')
                        ->where('t.active = 1')
                        ->andWhere('t.empresa = :empresa_id')
                        ->setParameter('empresa_id', $this->empresa->getId());
                },
                'multiple' => false,
                'required' => true
            ]);

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => ItemInvoiceReembolso::class,
        ]);
    }
}
