<?php

namespace App\Form;

use App\Entity\Model\ItemInvoiceReembolso;
use App\Entity\Model\ItemPago;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;


class InvoiceReembolsoType extends AbstractInvoiceType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $newPago = new ItemPago();
        $builder->add('pagos', CollectionType::class, array(
            'entry_type' => 'App\Form\ItemPagoType',
            'allow_add' => true,
            'allow_delete' => true,
            'prototype' => true,
            'by_reference' => false,
            'label' => false,
            'prototype_data' => $newPago,

        ));

        $newReembolso = new ItemInvoiceReembolso();
        $builder->add('reembolsos', CollectionType::class, array(
            'entry_type' => 'App\Form\ItemInvoiceReembolsoType',
            'allow_add' => true,
            'allow_delete' => true,
            'prototype' => true,
            'by_reference' => false,
            'label' => false,
            'prototype_data' => $newReembolso,

        ));

        /*->add('due_date', DateType::class, [
                'widget' => 'single_text',
                'label' => 'form.due_date',
                'translation_domain' => 'liquidacion',
            ])
            ->add('forcefully_closed', null, [
                'label' => 'form.forcefully_closed',
                'translation_domain' => 'liquidacion',
            ])
            ->add('sent_by_email', null, [
                'label' => 'form.sent_by_email',
                'translation_domain' => 'liquidacion',
            ])
            */;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\Invoice',
        ]);
    }
}
