<?php

namespace App\Form;

use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\OptionsResolver\OptionsResolver;


class CreditoType extends AbstractCreditoType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder->add('serieDocSustento', null, [
                'required' => true,
                'label' => 'form.faserie',
                'attr' => ['maxlength' => 6, 'minlength' => 6, 'class'=>'intTextBox', 'autocomplete' => 'off'],
                'translation_domain' => 'invoice',
            ])
            ->add('numeroDocSustento', null, [
                'required' => true,
                'label' => 'form.fanumero',
                'attr' => ['maxlength' => 9, 'class'=>'intTextBox', 'autocomplete' => 'off'],
                'translation_domain' => 'invoice',
            ])

            ->add('fecDocSustento', DateType::class, [
                'required' => true,
                'widget' => 'single_text',
                'label' => 'form.fafecha',
                'translation_domain' => 'invoice',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('motivo', null, [
                'required' => true,
                'attr' => ['class'=>'sv_uppercase', 'autocomplete' => 'off'],
                'label' => 'form.ncmotivo',
                'translation_domain' => 'invoice',
            ])
            /*->add('due_date', DateType::class, [
                'widget' => 'single_text',
                'label' => 'form.due_date',
                'translation_domain' => 'invoice',
            ])
            ->add('forcefully_closed', null, [
                'label' => 'form.forcefully_closed',
                'translation_domain' => 'invoice',
            ])
            ->add('sent_by_email', null, [
                'label' => 'form.sent_by_email',
                'translation_domain' => 'invoice',
            ])
            */
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Ncredito::class,
        ]);
    }
}
