<?php

namespace App\Form\Admin;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ClienteType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $planes = $options['planes'];

        $builder
            ->add('razonSocial', TextType::class, [
                'required' => true,
                'label' => 'form.company_name',
                'attr' => ['class'=>'sv_uppercase','readonly'=>'readonly'],
                'translation_domain' => 'config',
            ])
            ->add('ruc', TextType::class, [
                'required' => true,
                'attr' => ['readonly'=>'readonly'],
                'label' => 'form.company_identification',
                'translation_domain' => 'config',
            ])
            ->add('enabled', ChoiceType::class, [
                'label' => 'Habilitado',
                'required' => true,
                'choices' => array(
                    'form.si' => false,
                    'form.no' => true,
                ),
                'translation_domain' => 'config',
            ])
            ->add('mensaje', TextareaType::class, [
                'required' => false,
                //'attr' => ['readonly'=>'readonly'],
                'label' => 'Mensaje',
                'translation_domain' => 'config',
            ])
            ->add('plan', ChoiceType::class, [
                'label' => 'Plan',
                'required' => true,
                'choices' => $planes,
                'translation_domain' => 'config',
            ])
            ->add('puedefacturar', ChoiceType::class, [
                'label' => 'Puede Facturar',
                'required' => true,
                'choices' => array(
                    'form.si' => 1,
                    'form.no' => 0,
                ),
                'translation_domain' => 'config',
            ])
            ->add('cmp_contratados', TextType::class, [
                'required' => false,
                //'attr' => ['readonly'=>'readonly'],
                'label' => 'Doc. Contratados',
                'translation_domain' => 'config',
            ])
            ->add('cmp_emitidos', TextType::class, [
                'required' => false,
                //'attr' => ['readonly'=>'readonly'],
                'label' => 'Doc. Emitidos',
                'translation_domain' => 'config',
            ])
            ->add('tipoAmbiente', ChoiceType::class, [
                'label' => 'form.ambiente',
                'required' => true,
                'choices' => array(
                    'form.pruebas' => '1',
                    'form.produccion' => '2',
                ),
                'translation_domain' => 'config',
            ])
            ->add('fecha_caduca', DateType::class, [
                'label' => 'Fecha Caduca',
                'widget' => 'single_text',
                'required' => false,
            ])
            ->add('create_date', DateType::class, [
                'label' => 'Fecha Creacion',
                'attr' => ['readonly'=>'readonly'],
                'widget' => 'single_text',
                'required' => false,
            ])
            ->add('rutaPago', FileType::class, [
                'required' => false,
                'label' => 'Pago',
                'row_attr' =>['id'=>'demo'],
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
        ;

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'planes' => [],
        ]);
    }
}
