<?php

namespace App\EventListener;

use App\Entity\Model\Invoice;
use App\Entity\Model\Item;
use App\Entity\Model\PlacasSocios;
use App\Entity\Model\TransporteSocio;
use Doctrine\ORM\Event\OnFlushEventArgs;

class TransporteListener
{
    public function onFlush(OnFlushEventArgs $args)
    {
        try {
            $em = $args->getObjectManager();
            //$mi_em = $em->getEm();
            $uow = $em->getUnitOfWork();

            foreach ($uow->getScheduledCollectionUpdates() as $collection) {
                $entity = $collection->getOwner();

                if ($entity instanceof TransporteSocio) {
                    foreach ($collection->getInsertDiff() as $itemInserted) {
                        if ($itemInserted instanceof PlacasSocios) {
                            $metadata = $em->getClassMetadata(get_class($itemInserted));
                            $itemInserted->setTransportesocio($entity);
                            //$em->persist($itemInserted);
                            $uow->recomputeSingleEntityChangeSet($metadata, $itemInserted);
                        }
                    }
                }
                /*else{
                    if ($entity instanceof Item) {
                        $result = $em->getRepository(Invoice::class)->findByItem($entity);
                        foreach ($result as $invoice) {
                            $metadata = $em->getClassMetadata(Invoice::class);
                            $invoice->checkAmounts();
                            $uow->recomputeSingleEntityChangeSet($metadata, $invoice);
                        }
                    }
                }*/
            }
        }
        catch (\Exception $ex){

        }
    }
}
