<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 15/8/18
 * Time: 12:23
 */

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;
/**
 * App\Entity\Model\TipoRetencion
 *
 * @ORM\Table()
 * @ORM\Entity(repositoryClass="App\Repository\TipoRetencionRepository")
 */
class TipoRetencion
{
    /**
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id = null;

    /**
     * @var date $create_date
     *
     * @ORM\Column(name="create_date", type="date", nullable=true)
     */

    private $create_date;

    /**
     * @ORM\Column(name="name", type="string", length=191)
     */
    private $name = null;

    /**
     * @ORM\Column(name="codigo", type="string", length=5)
     */
    private  $codigo = null;

    /**
     * @ORM\Column(name="tipo", type="string", length=1)
     */
    private  $tipo = null;

    /**
     * @var decimal $porcentaje
     *
     * @ORM\Column(type="decimal", precision=5, scale=2)
     */
    private $porcentaje;

    /**
     * @var boolean $enabled
     *
     * @ORM\Column(name="enabled", type="boolean")
     */
    private $enabled = 1;

    /**
     * Empresa constructor.
     */
    public function __construct()
    {
        $this->create_date = new \DateTime();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * @param string $codigo
     */
    public function setCodigo(string $codigo)
    {
        $this->codigo = $codigo;
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    /**
     * @return string
     */
    public function getTipo(): string
    {
        return $this->tipo;
    }

    /**
     * @param string $tipo
     */
    public function setTipo(string $tipo)
    {
        $this->tipo = $tipo;
    }

    /**
     * @return decimal
     */
    public function getPorcentaje()
    {
        return $this->porcentaje;
    }

    /**
     * @param decimal $porcentaje
     */
    public function setPorcentaje($porcentaje)
    {
        $this->porcentaje = $porcentaje;
    }


}
