<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Gedmo\Timestampable\Timestampable;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Product
 *
 * @ORM\Table(name="product", uniqueConstraints={@ORM\UniqueConstraint(name="product_unique", columns={
 *     "reference",
 *     "empresa_id"
 * })}))
 * @ORM\Entity(repositoryClass="App\Repository\ProductRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Product implements Timestampable
{
    //use TimestampableEntity;
    /**
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id = null;

    /**
     * @ORM\Column(name="slug", type="string", length=32, nullable=true, unique=true)
     */
    private  $slug = null;

    /**
     *
     * @ORM\Column(name="reference", type="string", length=25)
     * @Assert\NotBlank()
     */
    private  $reference = null;

    /**
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     */
    private  $description = null;

    /**
     *
     * @ORM\Column(name="price", type="decimal", precision=20, scale=6)
     * @Assert\NotBlank()
     */
    private  $price = null;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Model\Item", mappedBy="product")
     */
    private $items;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Empresa")
     * @ORM\JoinColumn(name="empresa_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $empresa;

    /**
     * @ORM\Column(name="iva", type="integer", nullable=true)
     */
    private  $iva = null;

    /**
     * @ORM\Column(name="codauxiliar", type="string", length=20, nullable=true)
     */
    private  $codauxiliar = null;

    /**
     * @ORM\PrePersist
     */
    public function setSlug()
    {
        $this->slug = md5('sv_'.$this->empresa->getId().$this->reference);
    }

    /**
     * @return string
     */
    public function getSlug(): string
    {
        return $this->slug;
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return Product
     */
    public function setReference($reference)
    {
        $this->reference = strtoupper($reference);

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Product
     */
    public function setDescription($description)
    {
        $this->description = strtoupper($description);

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set price
     *
     * @param string $price
     *
     * @return Product
     */
    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * Get price
     *
     * @return string
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function jsonSerialize()
    {
        return [
            'id' => $this->getId(),
            'reference' => $this->getReference(),
            'price' => $this->getPrice(),
            'description' => $this->getDescription(),
        ];
    }

    public function label()
    {
        return $this->getReference();
    }

    public function __toString()
    {
        return $this->label();
    }

    /**
     * @return mixed
     */
    public function getEmpresa()
    {
        return $this->empresa;
    }

    /**
     * @param mixed $empresa
     */
    public function setEmpresa($empresa)
    {
        $this->empresa = $empresa;
    }

    /**
     * @return int
     */
    public function getIva()
    {
        return $this->iva;
    }

    /**
     * @param int $iva
     */
    public function setIva($iva)
    {
        $this->iva = $iva;
    }

    /**
     * @return string
     */
    public function getCodauxiliar()
    {
        return $this->codauxiliar;
    }

    /**
     * @param string $codauxiliar
     */
    public function setCodauxiliar($codauxiliar)
    {
        $this->codauxiliar = $codauxiliar;
    }


}
