<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Validator\Constraints as Assert;
/**
 *
 * @ORM\Table()
 * @ORM\Entity(repositoryClass="App\Repository\PropertyRepository")
 */
class PlacasSocios
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var date $create_date
     *
     * @ORM\Column(name="create_date", type="date", nullable=true)
     */

    private $create_date;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=191)
     */
    private $name;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\TransporteSocio", inversedBy="placas")
     * @ORM\JoinColumn(name="transportesocio_id", referencedColumnName="id", onDelete="SET NULL")
     * @Assert\NotBlank(allowNull=false, message="empresa no puede ser nulo, corregir en codigo fuente")
     */
    private $transportesocio;


    /**
     * Empresa constructor.
     */
    public function __construct()
    {
        $this->create_date = new \DateTime();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    public function __toString()
    {
        return $this->name;
    }

    /**
     * @param mixed $transportesocio
     */
    public function setTransportesocio($transportesocio): void
    {
        $this->transportesocio = $transportesocio;
    }

    /**
     * Get value
     *
     * @return string
     */
    public function getValue()
    {
        return $this->name;
    }
}
