<?php

namespace App\Entity\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * App\Entity\Model\Destinatario
 *
 * @ORM\Entity(repositoryClass="App\Repository\ItemRepository")
 */
class Destinatario
{

    /**
     * @var mixed|string
     */
    public $invoicing_address;

    /**
     *
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id = null;

    /**
     * @ORM\Column(nullable=true)
     */
    private  $name = null;

    /**
     *
     * @ORM\Column(type="string", length=200)
     * @Assert\NotBlank(message = "Ingrese direccion destino")
     */
    private  $dir_destino;

    /**
     *
     * @ORM\Column(type="string", length=200)
     * @Assert\NotBlank(message = "Ingrese motivo translado")
     */
    private  $motivo_traslado;

    /**
     * @ORM\Column(type="string", length=200, nullable=true)
     */
    private  $ruta = null;

    /**
     * @ORM\Column(type="string", length=3, nullable=true)
     */
    private  $cod_estab_destino = null;

    /**
     * @ORM\Column(type="string", length=20, nullable=true)
     */
    private  $doc_aduanero = null;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Customer")
     * @ORM\JoinColumn(name="customer_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $customer;

    /**
     *
     * @ORM\Column(name="customer_name", type="string", length=255)
     * @Assert\NotBlank(message = "Ingrese el nombre del cliente")
     */
    private  $customer_name = null;

    /**
     *
     * @ORM\Column(name="customer_identification", type="string", length=128, nullable=true)
     * @Assert\NotBlank(message = "Ingrese el número de identificación del cliente")
     */
    private  $customer_identification = null;

    /**
     *
     * @ORM\Column(name="customer_email", type="string", length=255)
     * @Assert\NotBlank(message = "Ingrese el correo electrónico del cliente")
     * @Assert\Email()
     */
    private  $customer_email = null;


    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Invoice")
     * @ORM\JoinColumn(name="invoice_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $invoice;

    /**
     * @ORM\Column(name="invoice_serie", type="string", length=6, nullable=true)
     */
    private  $invoice_serie = null;

    /**
     * @ORM\Column(name="invoice_numero", type="string", length=9, nullable=true)
     */
    private  $invoice_numero = null;

    /**
     * @var date $invoice_fecha
     *
     * @ORM\Column(name="invoice_fecha", type="date", nullable=true)
     * @Assert\Type("\DateTime")
     */
    private $invoice_fecha = null;

    /**
     * @ORM\Column(name="invoice_autorizacion", type="string", length=49, nullable=true)
     */
    private  $invoice_autorizacion = null;

    /**
     * @ORM\ManyToMany(targetEntity="App\Entity\Model\ItemGuia", cascade={"all"}, inversedBy="guiaremision")
     * @ORM\JoinTable(name="destinatarios_items",
     *      joinColumns={@ORM\JoinColumn(name="destinatario_id", referencedColumnName="id", onDelete="CASCADE")},
     *      inverseJoinColumns={@ORM\JoinColumn(name="itemguia_id", referencedColumnName="id", unique=true, onDelete="CASCADE")}
     * )
     * @Assert\NotBlank()
     */
    private $items;

    public function __construct()
    {
        $this->items = new ArrayCollection();
    }

    /**
     * TODO: provide the serie .
     */
    public function __toString()
    {
        return "";
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return \App\Entity\Model\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }

    /**
     * @param mixed $customer
     */
    public function setCustomer($customer)
    {
        $this->customer = $customer;
    }

    /**
     * Set customer parameters from customer entity.
     *
     * @param App\Entity\Model\Customer $customer
     */
    public function setFromCustomer(Customer $customer)
    {
        if (empty($this->customer_name) && $customer->getName()) {
            $this->customer_name = $customer->getName();
        }

        if (empty($this->customer_email) && $customer->getEmail()) {
            $this->customer_email = $customer->getEmail();
        }

        if (empty($this->customer_identification) && $customer->getIdentification()) {
            $this->customer_identification = $customer->getIdentification();
        }

        if (empty($this->invoicing_address) && $customer->getInvoicingAddress()) {
            $this->invoicing_address = $customer->getInvoicingAddress();
        }

    }

    /**
     * Set customer_name
     *
     * @param string $customerName
     */
    public function setCustomerName($customerName)
    {
        $this->customer_name = $customerName;
    }

    /**
     * Get customer_name
     *
     * @return string
     */
    public function getCustomerName()
    {
        return $this->customer_name;
    }

    /**
     * Set customer_identification
     *
     * @param string $customerIdentification
     */
    public function setCustomerIdentification($customerIdentification)
    {
        $this->customer_identification = $customerIdentification;
    }

    /**
     * Get customer_identification
     *
     * @return string
     */
    public function getCustomerIdentification()
    {
        return $this->customer_identification;
    }

    /**
     * Set customer_email
     *
     * @param string $customerEmail
     */
    public function setCustomerEmail($customerEmail)
    {
        $this->customer_email = $customerEmail;
    }

    /**
     * Get customer_email
     *
     * @return string
     */
    public function getCustomerEmail()
    {
        return $this->customer_email;
    }


    /**
     * @return \App\Entity\Model\Invoice
     */
    public function getinvoice()
    {
        return $this->invoice;
    }

    /**
     * @param mixed $invoice
     */
    public function setInvoice($invoice)
    {
        $this->invoice = $invoice;
    }

    /**
     * Add items
     *
     * @param App\Entity\Model\ItemGuia $item
     */
    public function addItem(ItemGuia $item)
    {
        $this->items[] = $item;
    }

    /**
     * Get items
     *
     * @return Doctrine\Common\Collections\Collection
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * removeItem
     * removes an item and recalculcates amounts
     *
     * @param mixed $mixed : can be an integer or an item instance
     *                       - if an integer, removes the item with
     *                         that position in the collection
     *                       - if an instance, removes that item
     * @author JoeZ99 <jzarate@gmail.com>
     */
    public function removeItem($mixed)
    {
        if ($mixed instanceof ItemGuia) {
            $items = $this->getItems();
            foreach ($items as $ref => $item) {
                if ($item === $mixed) {
                    unset($items[$ref]);
                    break;
                }
            }
        } elseif (is_int($mixed)) {
            unset($this->items[$mixed]);
        }

    }

    /**
     * @return string
     */
    public function getDirDestino()
    {
        return $this->dir_destino;
    }

    /**
     * @param string $dir_destino
     */
    public function setDirDestino($dir_destino)
    {
        $this->dir_destino = $dir_destino;
    }

    /**
     * @return string
     */
    public function getMotivoTraslado()
    {
        return $this->motivo_traslado;
    }

    /**
     * @param string $motivo_traslado
     */
    public function setMotivoTraslado($motivo_traslado)
    {
        $this->motivo_traslado = $motivo_traslado;
    }

    /**
     * @return string
     */
    public function getRuta()
    {
        return $this->ruta;
    }

    /**
     * @param string $ruta
     */
    public function setRuta($ruta)
    {
        $this->ruta = $ruta;
    }

    /**
     * @return string
     */
    public function getCodEstabDestino()
    {
        return $this->cod_estab_destino;
    }

    /**
     * @param string $cod_estab_destino
     */
    public function setCodEstabDestino($cod_estab_destino)
    {
        $this->cod_estab_destino = $cod_estab_destino;
    }

    /**
     * @return string
     */
    public function getDocAduanero()
    {
        return $this->doc_aduanero;
    }

    /**
     * @param string $doc_aduanero
     */
    public function setDocAduanero($doc_aduanero)
    {
        $this->doc_aduanero = $doc_aduanero;
    }


    /**
     * Set invoice_fecha
     *
     * @param date $invoice_fecha
     */
    public function setInvoiceFecha($issueDate)
    {
        $this->invoice_fecha = $issueDate instanceof \DateTime ?
            $issueDate : new \DateTime($issueDate);
    }

    /**
     * Get invoice_fecha
     *
     * @return date
     */
    public function getinvoiceFecha()
    {
        return $this->invoice_fecha;
    }

    /**
     * @return string
     */
    public function getInvoiceSerie()
    {
        return $this->invoice_serie;
    }

    /**
     * @param string $invoice_serie
     */
    public function setInvoiceSerie($invoice_serie)
    {
        $this->invoice_serie = $invoice_serie;
    }

    /**
     * @return string
     */
    public function getInvoiceNumero()
    {
        return $this->invoice_numero;
    }

    /**
     * @param string $invoice_numero
     */
    public function setInvoiceNumero($invoice_numero)
    {
        $this->invoice_numero = $invoice_numero;
    }

    /**
     * @return string
     */
    public function getInvoiceAutorizacion()
    {
        return $this->invoice_autorizacion;
    }

    /**
     * @param string $invoice_autorizacion
     */
    public function setInvoiceAutorizacion($invoice_autorizacion)
    {
        $this->invoice_autorizacion = $invoice_autorizacion;
    }


}
