<?php

namespace App\Electronico\NotaCreditos;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;


class InfoNotaCredito
{


    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaEmision")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaEmision;

    /**
     * @Serializer\Type("string")
     * @SerializedName("dirEstablecimiento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $dirEstablecimiento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("tipoIdentificacionComprador")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tipoIdentificacionComprador;

    /**
     * @Serializer\Type("string")
     * @SerializedName("razonSocialComprador")
     * @Serializer\XmlElement(cdata=false)
     */
    private $razonSocialComprador;

    /**
     * @Serializer\Type("string")
     * @SerializedName("identificacionComprador")
     * @Serializer\XmlElement(cdata=false)
     */
    private $identificacionComprador;

    /**
     * @Serializer\Type("string")
     * @SerializedName("contribuyenteEspecial")
     * @Serializer\XmlElement(cdata=false)
     */
    private $contribuyenteEspecial;

    /**
     * @Serializer\Type("string")
     * @SerializedName("obligadoContabilidad")
     * @Serializer\XmlElement(cdata=false)
     */
    private $obligadoContabilidad;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codDocModificado")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codDocModificado;

    /**
     * @Serializer\Type("string")
     * @SerializedName("numDocModificado")
     * @Serializer\XmlElement(cdata=false)
     */
    private $numDocModificado;

    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaEmisionDocSustento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaEmisionDocSustento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("totalSinImpuestos")
     * @Serializer\XmlElement(cdata=false)
     */
    private $totalSinImpuestos;

    /**
     * @Serializer\Type("string")
     * @SerializedName("valorModificacion")
     * @Serializer\XmlElement(cdata=false)
     */
    private $valorModificacion;

    /**
     * @Serializer\XmlElement(cdata=false)
     */
    private $moneda = 'DOLAR';

    /**
     * @SerializedName("totalConImpuestos")
     * @XmlList(inline = false, entry = "totalImpuesto")
     */
    private $totalConImpuestos;

    /**
     * @Serializer\Type("string")
     * @SerializedName("motivo")
     * @Serializer\XmlElement(cdata=false)
     */
    private $motivo;

    public function __construct()
    {
        /*$this->propina=number_format(0, 2, '.', '');*/
    }

    /**
     * @return mixed
     */
    public function getFechaEmision()
    {
        return $this->fechaEmision;
    }

    /**
     * @param mixed $fechaEmision
     */
    public function setFechaEmision($fechaEmision)
    {
        $this->fechaEmision = $fechaEmision;
    }

    /**
     * @return mixed
     */
    public function getDirEstablecimiento()
    {
        return $this->dirEstablecimiento;
    }

    /**
     * @param mixed $dirEstablecimiento
     */
    public function setDirEstablecimiento($dirEstablecimiento)
    {
        $this->dirEstablecimiento = $dirEstablecimiento;
    }

    /**
     * @return mixed
     */
    public function getContribuyenteEspecial()
    {
        return $this->contribuyenteEspecial;
    }

    /**
     * @param mixed $contribuyenteEspecial
     */
    public function setContribuyenteEspecial($contribuyenteEspecial)
    {
        $this->contribuyenteEspecial = $contribuyenteEspecial;
    }

    /**
     * @return mixed
     */
    public function getObligadoContabilidad()
    {
        return $this->obligadoContabilidad;
    }

    /**
     * @param mixed $obligadoContabilidad
     */
    public function setObligadoContabilidad(bool  $obligadoContabilidad)
    {
        $this->obligadoContabilidad = $obligadoContabilidad ? 'SI' : 'NO';
    }

    /**
     * @return mixed
     */
    public function getTipoIdentificacionComprador()
    {
        return $this->tipoIdentificacionComprador;
    }

    /**
     * @param mixed $tipoIdentificacionComprador
     */
    public function setTipoIdentificacionComprador($tipoIdentificacionComprador)
    {
            $this->tipoIdentificacionComprador = $tipoIdentificacionComprador;
    }


    /**
     * @return mixed
     */
    public function getRazonSocialComprador()
    {
        return $this->razonSocialComprador;
    }

    /**
     * @param mixed $razonSocialComprador
     */
    public function setRazonSocialComprador($razonSocialComprador)
    {
        $this->razonSocialComprador = $razonSocialComprador;
    }

    /**
     * @return mixed
     */
    public function getIdentificacionComprador()
    {
        return $this->identificacionComprador;
    }

    /**
     * @param mixed $identificacionComprador
     */
    public function setIdentificacionComprador($identificacionComprador)
    {
        $this->identificacionComprador = $identificacionComprador;
    }

    /**
     * @return mixed
     */
    public function getTotalSinImpuestos()
    {
        return $this->totalSinImpuestos;
    }

    /**
     * @param mixed $totalSinImpuestos
     */
    public function setTotalSinImpuestos($totalSinImpuestos)
    {
        $this->totalSinImpuestos = number_format($totalSinImpuestos, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getTotalConImpuestos()
    {
        return $this->totalConImpuestos;
    }

    /**
     * @param mixed $totalConImpuestos
     */
    public function setTotalConImpuestos(array  $impuestos)
    {
        $this->totalConImpuestos = $impuestos;
    }

    /**
     * @return mixed
     */
    public function getMoneda()
    {
        return $this->moneda;
    }

    /**
     * @param mixed $moneda
     */
    public function setMoneda($moneda)
    {
        $this->moneda = $moneda;
    }

    /**
     * @return mixed
     */
    public function getCodDocModificado()
    {
        return $this->codDocModificado;
    }

    /**
     * @param mixed $codDocModificado
     */
    public function setCodDocModificado($codDocModificado)
    {
        $this->codDocModificado = $codDocModificado;
    }

    /**
     * @return mixed
     */
    public function getNumDocModificado()
    {
        return $this->numDocModificado;
    }

    /**
     * @param mixed $numDocModificado
     */
    public function setNumDocModificado($numDocModificado)
    {
        $this->numDocModificado = $numDocModificado;
    }

    /**
     * @return mixed
     */
    public function getFechaEmisionDocSustento()
    {
        return $this->fechaEmisionDocSustento;
    }

    /**
     * @param mixed $fechaEmisionDocSustento
     */
    public function setFechaEmisionDocSustento($fechaEmisionDocSustento)
    {
        $this->fechaEmisionDocSustento = $fechaEmisionDocSustento;
    }

    /**
     * @return mixed
     */
    public function getValorModificacion()
    {
        return $this->valorModificacion;
    }

    /**
     * @param mixed $valorModificacion
     */
    public function setValorModificacion($valorModificacion)
    {
        $this->valorModificacion = $valorModificacion;
    }

    /**
     * @return mixed
     */
    public function getMotivo()
    {
        return $this->motivo;
    }

    /**
     * @param mixed $motivo
     */
    public function setMotivo($motivo)
    {
        $this->motivo = $motivo;
    }
}

