<?php

namespace App\Electronico\LiquidacionCompra;

use App\Electronico\InfoTributaria;
use JMS\Serializer\Annotation\Inline;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\XmlAttribute;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation\XmlRoot;

/** @XmlRoot("liquidacionCompra")
 */
class LiquidacionCompra
{

    /** @XmlAttribute
     *  @Type("string")
     */
    private $id ='comprobante';

    /** @XmlAttribute
     *  @Type("string")
     */
    private $version = '1.1.0';

    /**
     * @SerializedName("infoTributaria")
     */
    private $infoTributaria;

    /**
     * @SerializedName("infoLiquidacionCompra")
     */
    private $infoLiquidacionCompra;

    /**
     * @XmlList(inline = false, entry = "detalle")
     */
    private $detalles;


    /**
     * @XmlList(inline = false, entry = "reembolsoDetalle")
     */
    private $reembolsos;

    /**
     * @SerializedName("infoAdicional")
     * @XmlList(inline = false, entry = "campoAdicional")
     */
    private  $infoAdicional;


    public function __construct()
    {
        $this->infoLiquidacionCompra = new InfoLiquidacionCompra();
        $this->infoTributaria = new InfoTributaria();
    }

    /**
     * @return mixed
     */
    public function getInfoTributaria()
    {
        return $this->infoTributaria;
    }

    /**
     * @param mixed $infoTributaria
     */
    public function setInfoTributaria(InfoTributaria $infoTributaria)
    {
        $this->infoTributaria = $infoTributaria;
    }

    /**
     * @return mixed
     */
    public function getInfoLiquidacionCompra()
    {
        return $this->infoLiquidacionCompra;
    }

    /**
     * @param mixed $infoLiquidacionCompra
     */
    public function setInfoLiquidacionCompra(InfoLiquidacionCompra $infoLiquidacionCompra)
    {
        $this->infoLiquidacionCompra = $infoLiquidacionCompra;
    }

    /**
     * @return mixed
     */
    public function getInfoAdicional()
    {
        return $this->infoAdicional;
    }

    /**
     * @param mixed $infoAdicional
     */
    public function setInfoAdicional(array  $infoAdicional)
    {
        $this->infoAdicional = $infoAdicional;
    }

    /**
     * @return mixed
     */
    public function getDetalles()
    {
        return $this->detalles;
    }

    /**
     * @param mixed $detalles
     */
    public function setDetalles(array $detalles)
    {
        $this->detalles = $detalles;
    }

    /**
     * @return mixed
     */
    public function getReembolsos()
    {
        return $this->reembolsos;
    }

    /**
     * @param mixed $reembolsos
     */
    public function setReembolsos(array $reembolsos)
    {
        $this->reembolsos = $reembolsos;
    }
}
