<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 07/09/2017
 * Time: 17:57
 */

namespace App\Electronico;

use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;

class Impuesto
{
    /**
     * @Serializer\Type("integer")
     * @SerializedName("codigo")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $codigo;

    /**
     * @Serializer\Type("integer")
     * @SerializedName("codigoPorcentaje")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $codigoPorcentaje;

    /**
     * @Serializer\Type("string")
     * @SerializedName("tarifa")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tarifa;

    /**
     * @Serializer\Type("string")
     * @SerializedName("baseImponible")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $baseImponible;

    /**
     * @Serializer\Type("string")
     * @SerializedName("valor")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $valor;

    /**
     * @return mixed
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * @param mixed $codigo
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    }

    /**
     * @return mixed
     */
    public function getCodigoPorcentaje()
    {
        return $this->codigoPorcentaje;
    }

    /**
     * @param mixed $codigoPorcentaje
     */
    public function setCodigoPorcentaje($codigoPorcentaje)
    {
        $this->codigoPorcentaje = $codigoPorcentaje;
    }

    /**
     * @return mixed
     */
    public function getTarifa()
    {
        return $this->tarifa;
    }

    /**
     * @param mixed $tarifa
     */
    public function setTarifa($tarifa)
    {
        $this->tarifa = $tarifa;
    }

    /**
     * @return mixed
     */
    public function getBaseImponible()
    {
        return $this->baseImponible;
    }

    /**
     * @param mixed $baseImponible
     */
    public function setBaseImponible($baseImponible)
    {
        $this->baseImponible = number_format($baseImponible, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * @param mixed $valor
     */
    public function setValor($valor)
    {
        $this->valor = number_format($valor, 2, '.', '');
    }

}