<?php

namespace App\Electronico\Facturas;

use App\Electronico\InfoTributaria;
use JMS\Serializer\Annotation\Inline;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\XmlAttribute;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation\XmlRoot;

/** @XmlRoot("factura")
 */
class Factura
{

    /** @XmlAttribute
     *  @Type("string")
     */
    private $id ='comprobante';

    /** @XmlAttribute
     *  @Type("string")
     */
    private $version = '1.1.0';

    /**
     * @SerializedName("infoTributaria")
     */
    private $infoTributaria;

    /**
     * @SerializedName("infoFactura")
     */
    private $infoFactura;

    /**
     * @XmlList(inline = false, entry = "detalle")
     */
    private $detalles;

    /**
     * @XmlList(inline = false, entry = "reembolsoDetalle")
     */
    private $reembolsos;

    /**
     * @SerializedName("infoAdicional")
     * @XmlList(inline = false, entry = "campoAdicional")
     */
        private  $infoAdicional;


    public function __construct()
    {
        $this->infoFactura = new InfoFactura();
        $this->infoTributaria = new InfoTributaria();
    }

    /**
     * @return mixed
     */
    public function getInfoTributaria()
    {
        return $this->infoTributaria;
    }

    /**
     * @param mixed $infoTributaria
     */
    public function setInfoTributaria(InfoTributaria $infoTributaria)
    {
        $this->infoTributaria = $infoTributaria;
    }

    /**
     * @return mixed
     */
    public function getInfoFactura()
    {
        return $this->infoFactura;
    }

    /**
     * @param mixed $infoFactura
     */
    public function setInfoFactura(InfoFactura $infoFactura)
    {
        $this->infoFactura = $infoFactura;
    }

    /**
     * @return mixed
     */
    public function getInfoAdicional()
    {
        return $this->infoAdicional;
    }

    /**
     * @param mixed $infoAdicional
     */
    public function setInfoAdicional(array  $infoAdicional)
    {
        $this->infoAdicional = $infoAdicional;
    }

    /**
     * @return mixed
     */
    public function getDetalles()
    {
        return $this->detalles;
    }

    /**
     * @param mixed $detalles
     */
    public function setDetalles(array $detalles)
    {
        $this->detalles = $detalles;
    }

    /**
     * @return mixed
     */
    public function getReembolsos()
    {
        return $this->reembolsos;
    }

    /**
     * @param mixed $reembolsos
     */
    public function setReembolsos($reembolsos): void
    {
        $this->reembolsos = $reembolsos;
    }

}
