<?php

namespace App\Controller;

use App\Entity\Model\User;
use App\Service\EmFactory;
use DateTime;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class CoreController extends AbstractController
{
    /**
     * @Route("/", name="inicio")
     *
     */
    public function indexAction(EmFactory $emFactory): \Symfony\Component\HttpFoundation\Response
    {
        if (!$this->isGranted("IS_AUTHENTICATED_FULLY")) {
            return $this->redirectToRoute("app_login");
        }

        $user = $this->getUser();
        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);

        if ($user->getUsername() == 'efcampoverde2')
            $empresa = $empresaRepo->find(22);
        else
            $empresa = $empresaRepo->findOneByUser($user->getRuc());

        if ($empresa)
            return $this->redirectToRoute('dashboard_index');
        else
            return $this->redirectToRoute('global_settings');

    }

    /**
     * @Route("/item/autocomplete-description", name="item_autocomplete_description")
     */
    public function autocompleteDescriptionAction(EmFactory $emFactory, Request $request): \Symfony\Component\HttpFoundation\Response
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $entities = $em->getRepository(\App\Entity\Model\Product::class)
            ->findLikeDescripcion($request->get('term'), $empresa->getId());

        return new JsonResponse($entities);
    }

    /**
     * @Route("/item/autocomplete-provreembolso", name="item_autocomplete_provreembolso")
     */
    public function autocompleteProvReembolsoAction(EmFactory $emFactory, Request $request): \Symfony\Component\HttpFoundation\Response
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);

        if ($user->getUsername() == 'efcampoverde2')
            $empresa = $empresaRepo->findOneBy(22);
        else
            $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $entities = $em
            ->getRepository(\App\Entity\Model\Provider::class)
            ->findLike($request->get('term'), $empresa->getId());

        return new JsonResponse($entities);
    }

    /**
     * @Route("/core/notificaciones", name="core_notificaciones")
     */
    public function notificacionesAction(EmFactory $emFactory): \Symfony\Component\HttpFoundation\Response
    {
        $alerta = [];
        $alertas = null;
        $firma = $this->caducaFirma($emFactory);

        if($firma != null){
            $alerta['prioridad'] = $firma['prioridad'];
            $alerta['mensaje'] = 'Firma caduca el: '. $firma['caduca'];

            $alertas[]= $alerta;
        }

        return $this->render(
            'partial\notificaciones.html.twig',
            ['alerts' => $alertas]
        );
    }

    private function caducaFirma(EmFactory $emFactory)
    {
        $firma = null;
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $fec_firma = $empresa->getFechaCaducaFirma();

        if($fec_firma == null)
            return null;

        $date1 = $fec_firma;
        $date2 = new DateTime("now");

        $diff = $date1->diff($date2);
        //$dias= $this->get_format($diff);

        $dias = $diff->days;

        if ($dias >= 60) {
            $firma['prioridad'] = 'text-green';
        } elseif ($dias >= 30 && $dias < 60) {
            $firma['prioridad'] = 'text-orange';
        } elseif ($dias < 30) {
            $firma['prioridad'] = 'text-red';
        }

        $firma['caduca'] = $fec_firma->format('d M Y');

        return $firma;

    }

    function get_format($df) {

        $str = '';
        $str .= ($df->invert == 1) ? '  ' : '';
        if ($df->y > 0) {
            // years
            $str .= ($df->y > 1) ? $df->y . ' Años ' : $df->y . ' Año ';
        }
         if ($df->m > 0) {
            // month
            $str .= ($df->m > 1) ? $df->m . ' Meses ' : $df->m . ' Mes ';
        }
         if ($df->d > 0) {
            // days
            $str .= ($df->d > 1) ? $df->d . ' Dias ' : $df->d . ' Dia ';
        }
         if ($df->h > 0) {
            // hours
            $str .= ($df->h > 1) ? $df->h . ' Horas ' : $df->h . ' Hora ';
        }

        /*if ($df->i > 0) {
            // minutes
            $str .= ($df->i > 1) ? $df->i . ' Minutos ' : $df->i . ' Minuto ';
        } if ($df->s > 0) {
            // seconds
            $str .= ($df->s > 1) ? $df->s . ' Segundos ' : $df->s . ' Segundo ';
        }*/

        return $str;
    }
}
