<?php

namespace App\Controller;

use App\Electronico\Comprobante;
use App\Entity\Model\AbstractInvoice;
use App\Entity\Model\Customer;
use App\Entity\Model\Empresa;
use App\Entity\Model\FormaPago;
use App\Entity\Model\Invoice;
use App\Entity\Model\Item;
use App\Entity\Model\ItemPago;
use App\Entity\Model\Model\Emisor;
use App\Entity\Model\Tax;
use App\Entity\Model\User;
use App\Form\EmpresaType;
use App\Service\EmFactory;
use App\Util\RestApiFunciones;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use JMS\Serializer\SerializerBuilder;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Config\Definition\Exception\Exception;
use Symfony\Component\HttpFoundation\File\Exception\FileException;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * @Route("/api")
 */
class ApiController extends AbstractController
{
    /**
     * @Route("/genfa")
     */
    public function genFaAction(EmFactory $emFactory, Request $request, LoggerInterface $logger)
    {
         
        
                
        try {
            
            $autorizacion = $request->headers->get('Authorization');
            
        
            $aux = explode("X", $autorizacion);

            if ($aux[0] != "ShaRaPp150108.") {
                $response = ['error' => true, 'message' => "no esta autorizado para uso del sistema"];

                return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
            }

            if (strlen($_POST['data']) === 0) {
                $response = array(
                    'error' => true,
                    'message' => "array datos en blanco",
                );

                $logger->warning("array datos en blanco");
                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            }

            $aux = explode("X", $autorizacion);

            $data2 = $request->request->get('data');

            $data1 = base64_decode($data2);

            //$logger->warning('captura app '.$data1);

            $data = json_decode($data1, TRUE);

            if (!isset($data['cab'])) {
                $response = array(
                    'error' => true,
                    'message' => 'array cab no existe',
                );

                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            }

            if (!isset($data['det'])) {
                $response = array(
                    'error' => true,
                    'message' => 'array det no existe',
                );

                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            }

            //$aux = explode("X", $autorizacion);

            $ruc = $this->cleanParametro($data["cab"]["ruc"]);

            $em = $this->getDoctrine()->getManager('default');
            $userRepo = $em->getRepository(User::class);
            $user = $userRepo->findOneBy(['ruc' => $ruc]);
            if (!$user) {
                $response = array(
                    'error' => true,
                    'message' => 'user no existe',
                );

                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            }

            $emempresa = $emFactory->getEmDataBase($user->getDataBase());
            $empresaRepo = $emempresa->getRepository(Empresa::class);
            $empresa = $empresaRepo->findOneByUser($ruc);
            if (!$empresa) {
                $response = array(
                    'error' => true,
                    'message' => 'emisor no existe',
                );

                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            }

            $logger->info("clave post, es numero de ruc inicia lectura data");

            /*$total = $emempresa->getRepository(Invoice::class)->getFacturasxMes($empresa->getId());
            $plan = $empresa->getPlan();
            $planes = null;
            $msgcambioplan = "";
            if ($plan->getIlimitado() === false) {
                if ($total > floatval($plan->getNumFacMes())) {
                    $planesRepo = $emempresa->getRepository('App\Entity\Model\Planes');
                    $planes = $planesRepo->findTodos();
                    foreach ($planes as $key => $aux) {
                        if ($aux === $plan) {
                            unset($planes[$key]);
                            break;
                        }
                    }
                    //$this->addTranslatedMessage('Número de facturas emitidas excede del plan contratado', 'danger');
                    $msgcambioplan = 'Número de comprobantes emitidos excede del plan contratado.';
                    $cambioplan = true;

                    $response = array(
                        'error' => true,
                        'message' => $msgcambioplan,
                    );

                    header("HTTP/1.1 200 OK");
                    return new JsonResponse($response, 200);
                }
            }*/

            $invoice = new Invoice();
            $invoice->setEmpresa($empresa);

            foreach ($data["det"] as $item) {
                $newItem = new Item();

                $tax = $emempresa->getRepository('App\Entity\Model\Tax')->findTaxPorcentaje(intval($item['porcentaje']), $empresa->getId());

                if ($tax)
                    $newItem->setTaxes($tax);
                else if(intval($item['porcentaje']) === 5) {
                    $tax = new Tax();
                    $tax->setName("IVA 5");
                    $tax->setValue(5);
                    $tax->setActive(true);
                    $tax->setIsDefault(false);
                    $tax->setEmpresa($empresa);

                    $em->persist($tax);
                    $em->flush();
                    $newItem->setTaxes($tax);
                }


                $newItem->setUnitaryCost(floatval($item['precio']));
                $newItem->setDiscountAmount(floatval($item['descuento2']));
                $newItem->setQuantity(floatval($item['cantidad']));
                $newItem->setDescription($this->cleanParametro($item['descripcion']));
                $newItem->setTasaImpuesto(intval($item['porcentaje']));

                $invoice->addItem($newItem);

            }

            $itemPago = new ItemPago();
            $itemPago->setPlazo(0);
            $itemPago->setValor(floatval($data["cab"]["total"]));
            $itemPago->setTiempo("dias");

            if(isset($data['cab']['unidadTiempo']))
                $itemPago->setTiempo($data['cab']['unidadTiempo']);

            if(isset($data['cab']['plazo']))
                $itemPago->setPlazo($data['cab']['plazo']);

            $fpago = $emempresa->getRepository(FormaPago::class)->findFormaPagoByCodigo($this->cleanParametro($data['cab']['formapago']));

            if ($fpago)
                $itemPago->setFormapago($fpago);

            $invoice->addPago($itemPago);

            $cliente = $emempresa->getRepository(Customer::class)->findIdentificacionApi($this->cleanParametro($data['cab']['ruccliente']), $empresa->getId());

            //$cliente = new Customer();
            if (!$cliente) {

                $cliente = new Customer();
                $cliente->setEmpresa($empresa);
                $ruccliente = $this->cleanParametro($data['cab']['ruccliente']);

                $cliente->setIdentification($ruccliente);
                $cliente->setName($this->cleanParametro($data['cab']['cliente']));
                $cliente->setEmail($data['cab']['email']);
                $cliente->setTelefono($this->cleanParametro($data['cab']['telefono']));
                $cliente->setInvoicingAddress($this->cleanParametro($data['cab']['direccion']));

                $tpdoc = '04';
                if ($ruccliente === '9999999999999') {
                    $tpdoc = '07';
                } else {
                    if (strlen($ruccliente) === 10)
                        $tpdoc = '05';
                }

                $cliente->setTipoDocumento($tpdoc);
                $emempresa->persist($cliente);
                $emempresa->flush();
            }

            $auxdemi = date_create_from_format('d/m/Y', $data["cab"]["emision"]);
            $invoice->setIssueDate($auxdemi);

            $invoice->setCustomer($cliente);

            $invoice->setCustomerName($cliente->getName());
            $invoice->setCustomerIdentification($cliente->getIdentification());
            $invoice->setCustomerEmail($cliente->getEmail());
            $invoice->setInvoicingAddress($cliente->getInvoicingAddress());

            $secuencial = $this->cleanParametro($data["cab"]["secuencial"]);
            $invoice->setSerie(substr($secuencial, 0, 6));
            $invoice->setNumber(substr($secuencial, 6));

            $numero = $emempresa->getRepository(Invoice::class)->findOneBy([
                'number' => $invoice->getNumber(),
                'empresa' => $empresa->getId(),
                'serie' => $invoice->getSerie()
            ]);

            if ($numero) {
                $response = array(
                    'error' => true,
                    'message' => "secuencial ya se encuentra registrado"
                );

                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            }

            $this->cargarImpuestos($invoice);
            $invoice->setEmpresa($empresa);
            $invoice->setUsuario($user->getId());
            $invoice->setAmbiente($empresa->getTipoAmbiente());

            /*if ($plan->getIlimitado() === false) {
                $monto = $invoice->getTotalFactura();
                $maximo = floatval($plan->getValMaxFac());
                if ($monto > $maximo) {
                    $planesRepo = $emempresa->getRepository('App\Entity\Model\Planes');
                    $planes = $planesRepo->findTodos();
                    foreach ($planes as $key => $aux) {
                        if ($aux === $plan) {
                            unset($planes[$key]);
                            break;
                        }
                    }
                    $msgcambioplan = 'Monto facturado excede el valor permitido del plan contratado.';
                    $cambioplan = true;

                    $response = array(
                        'error' => true,
                        'message' => $msgcambioplan,
                    );

                    header("HTTP/1.1 200 OK");
                    return new JsonResponse($response, 200);
                }
            }*/

            $emempresa->persist($invoice);
            $emempresa->flush();
            $invoice_slug = $invoice->getSlug();

            $invoice_id = $invoice->getId();

            $error = false;
            $invoice = $this->generarXml($invoice, $error);

            if ($error) {
                $response = array(
                    'error' => true,
                    'message' => $invoice,
                );

                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            }

            $app_url = $this->getParameter('api_url');

            $error = false;
            $resp = RestApiFunciones::enviarComprobante($error, $invoice->getXml(), $invoice->getClaveAcceso(), $app_url);
            
            // NO ES MI CODIGO
             /*$xmlapi = $invoice->getXmlAutorizado();
            $respu = InvoiceController::showOnlinePdfActionAPI($invoice_id, $invoice_slug, $emFactory, $request, $user, $xmlapi);

            if ($error) {

                $response = array(
                    'error' => true,
                    'message' => $resp->message,
                );

                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            } else {
                if ($resp->estado === 'recibido') {
                    $error = false;
                    sleep(3);
                    $resp = $this->consultarAutorizacion($invoice, $error);

                    if ($error) {
                        $response = array(
                            'error' => true,
                            'message' => $resp,
                        );

                        header("HTTP/1.1 200 OK");
                        return new JsonResponse($response, 200);
                    }

                } else {
                    $invoice->setMensajeError($resp->message);
                    //$this->addTranslatedMessage($resp->message, 'danger');
                    $em->persist($invoice);
                    $em->flush();

                    $response = array(
                        'error' => true,
                        'message' => $resp->message,
                    );

                    header("HTTP/1.1 200 OK");
                    return new JsonResponse($response, 200);
                }
            }
            */

            if ($resp->estado === 'recibido') {
                $error = false;
                sleep(3);
                $resp = $this->consultarAutorizacion($invoice, $error);

                if ($error) {
                    $response = array(
                        'error' => true,
                        'message' => $resp,
                    );

                    header("HTTP/1.1 200 OK");
                    return new JsonResponse($response, 200);
                }

                $xmlapi = $invoice->getXmlAutorizado();

                $app_url = $this->getParameter('api_url').'facturaride.php';

                $respu = InvoiceController::showOnlinePdfActionAPI($invoice_id, $invoice_slug, $emFactory, $request, $user, $xmlapi, $app_url);

            } else {
                $invoice->setMensajeError($resp->message);
                //$this->addTranslatedMessage($resp->message, 'danger');
                $em->persist($invoice);
                $em->flush();

                $response = array(
                    'error' => true,
                    'message' => $resp->message,
                );

                header("HTTP/1.1 200 OK");
                return new JsonResponse($response, 200);
            }
            $xmlautorizado = $invoice->getXmlAutorizado();
            $xmlbase64Encoded = base64_encode($xmlautorizado);

            $response = array(
                'error' => false,
                'clave' => $invoice->getClaveAcceso(),
                'xmlautorizado' => $invoice->getXmlAutorizado(),
                'xmlbase64Encoded' => $xmlbase64Encoded,
                'fechaautorizado' => $invoice->getFechaAutorizacion(),
                'pdf_base64' => $respu,
                'invoice_id' => $invoice_id,
                'slug_id' => $invoice_slug,
                'user_id' => $user->getId(),
                /*'user_id' => $invoice_user_empresa,*/
                'empresa_ruc' =>  $ruc,
                'secuencial' =>  $secuencial,
            );

            return new JsonResponse($response, 200);
        } catch (\Exception $ex) {
            $response = array(
                'error' => true,
                'message' => $ex->getMessage(),
            );
        }

        return new JsonResponse($response, 200);
    }


    /**
     * @Route("/emisors/docphp/new")
     */
    public function newEmisorDocPhpAction(Request $request, EntityManagerInterface $entityManager): \Symfony\Component\HttpFoundation\Response
    {
        try {
            $autorizacion = $request->headers->get('Authorization');

            $aux = explode("X", $autorizacion);

            if ($aux[0] != "ShaRaPp150108.") {
                $response = ['error' => true, 'message' => "no esta autorizado para uso del sistema"];

                return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
            }

            $em = $entityManager;

            $data = $request->request->get('data');

            $emisor = new Emisor();

            $fileFirma = $request->files->get('firma');

            if ($fileFirma == null || empty($fileFirma)) {
                $response = ['error' => true, 'message' => "no se encontro firma valida"];

                return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
            }

            if ($fileFirma->guessExtension() != "bin") {
                $response = ['error' => true, 'message' => "formato archivo firma no es valido"];

                return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
            }

            $form = $this->createForm(EmpresaType::class, $emisor);

            $form->submit(json_decode($data, true, 512, JSON_THROW_ON_ERROR));

            if ($form->isValid()) {

                $uploadsDir = $this->getParameter('ruta_documentos') . $emisor->getRuc();

                if (!file_exists($uploadsDir)) {
                    mkdir($uploadsDir, 0755, true);
                }

                $fileName = $emisor->getRuc() . ".p12";
                // Move the file to the uploads directory.

                try {
                    $newFile = $fileFirma->move($uploadsDir, $fileName);
                    // Update the property to the new file name.
                    $emisor->setRutaFirma($uploadsDir . '/' . $newFile->getFileName());

                    //$aux = $newFile->getPath();
                } catch (FileException $fileException) {

                }

                $fileLogo = $request->files->get('logo');

                if ($fileLogo == null || empty($fileLogo)) {
                    $emisor->setRutaLogo(null);
                } else {

                    $fileName = "logo_" . $emisor->getRuc() . "." . $fileLogo->guessExtension();

                    try {
                        $newFile = $fileLogo->move($uploadsDir, $fileName);
                        // Update the property to the new file name.
                        $emisor->setRutaLogo($uploadsDir . '/' . $newFile->getFileName());

                        //$aux = $newFile->getPath();
                    } catch (FileException $fileException) {

                    }
                }

                $emisor = $form->getData();

                $repo = $em->getRepository('App:Empresa')->findEmisorRuc($emisor->getRuc());

                if ($repo) {
                    $emisor->setId($repo->getId());
                    $em->merge($emisor);
                }
                else {
                    $em->persist($emisor);

                    /*$resp = $this->crearTablaComprobantesEmisor($emisor->getRuc() . "_cmp");

                    if ($resp != null && strpos($resp, 'already exists') == false) {
                        $response = array(
                            'error' => true,
                            'message' => $resp,
                        );

                        return new JsonResponse($response, 200);
                    }
                    */

                }

                $em->flush();

            } else {

                $errors = $this->getErrorMessages($form);

                $response = ['error' => true, 'message' => $errors];

                return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
            }

            $response = ['error' => false, 'message' => 'registro procesado'];

            return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
        } catch (\Exception $exception) {
            $response = ['error' => true, 'message' => $exception->getMessage()];

        }

        return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
    }

    /**
     * @Route("/emisors/docphp/smtp")
     */
    public function editSmtpDocPhpAction(Request $request, EntityManagerInterface $entityManager): \Symfony\Component\HttpFoundation\Response
    {
        try {
            $autorizacion = $request->headers->get('Authorization');

            $aux = explode("X", $autorizacion);

            if ($aux[0] != "ShaRaPp150108.") {
                $response = ['error' => true, 'message' => "no esta autorizado para uso del sistema"];

                return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
            }

            $em = $entityManager;

            $data = $request->request->get('data');

            $emisor = new Emisor();

            $form = $this->createForm(EmpresaType::class, $emisor);

            $form->submit(json_decode($data, true, 512, JSON_THROW_ON_ERROR));

            if ($form->isValid()) {

                $emisor = $form->getData();

                $repo = $em->getRepository('App:Empresa')->findEmisorRuc($emisor->getRuc());

                if ($repo) {
                    $emisor->setId($repo->getId());
                    $em->merge($emisor);
                }
                else {
                    $em->persist($emisor);
                }

                $em->flush();

            } else {

                $errors = $this->getErrorMessages($form);

                $response = ['error' => true, 'message' => $errors];

                return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
            }

            $response = ['error' => false, 'message' => 'registro procesado'];

            return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
        } catch (\Exception $exception) {
            $response = ['error' => true, 'message' => $exception->getMessage()];

        }

        return new JsonResponse($response, \Symfony\Component\HttpFoundation\Response::HTTP_OK);
    }

    private function crearTablaComprobantesEmisor($nombreTabla)
    {
        $respuesta = null;
        try {

            $sql = "CREATE TABLE {$nombreTabla} (
                      id int(11) NOT NULL AUTO_INCREMENT,
                      create_date date DEFAULT NULL,
                      ruc varchar(15) COLLATE utf8_unicode_ci NOT NULL,
                      razon_social varchar(200) COLLATE utf8_unicode_ci NOT NULL,
                      clave_acceso varchar(49) COLLATE utf8_unicode_ci DEFAULT NULL,
                      recibido tinyint(1) DEFAULT NULL,
                      autorizado tinyint(1) DEFAULT NULL,
                      xml_autorizado longtext COLLATE utf8_unicode_ci DEFAULT NULL,
                      mensaje longtext COLLATE utf8_unicode_ci DEFAULT NULL,
                      emisor_id int(11) NOT NULL,
                      ambiente int(11) NOT NULL,
                      tipo varchar(2) COLLATE utf8_unicode_ci NOT NULL,
                      fec_auto varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                      PRIMARY KEY (id),
                      UNIQUE KEY clave_idx (clave_acceso),
                      KEY comprobante_emisid_idx (emisor_id)
                    ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

            $servername = $this->getParameter('database_host');
            $username = $this->getParameter('database_user');
            $password = $this->getParameter('database_password');
            $dbname = $this->getParameter('database_name');

            $conn = new mysqli($servername, $username, $password, $dbname);
            if ($conn->connect_error) {
                return "Connection failed: " . $conn->connect_error;
            }

            $respuesta = $conn->query($sql) === TRUE ? null : "Error creating table: " . $conn->error;

            $conn->close();

        } catch (\Exception $exception) {
            $respuesta = $exception->getMessage();
        }

        return $respuesta;
    }

    private function getErrorMessages(\Symfony\Component\Form\Form $form)
    {
        $errors = [];

        foreach ($form->getErrors() as $key => $error) {
            $template = $error->getMessageTemplate();
            $parameters = $error->getMessageParameters();

            foreach ($parameters as $var => $value) {
                $template = str_replace($var, $value, $template);
            }

            $errors[$key] = $template;
        }

        if ($form->count() !== 0) {
            foreach ($form as $child) {
                if (!$child->isValid()) {
                    $errors[$child->getName()] = $this->getErrorMessages($child);
                }
            }
        }

        return $errors;
    }

    protected function consultarAutorizacion(Invoice $invoice, &$error)
    {
        $error = false;
        $respuesta = null;
        try {
            $em = $this->getDoctrine()->getManager();

            $app_url = $this->getParameter('api_url');

            $error = false;

            $resp = RestApiFunciones::consultarAutoComprobante($error, $app_url, $invoice->getClaveAcceso());

            if ($error) {
                //$this->addTranslatedMessage($resp, 'danger');
                $respuesta = $resp;
                $error = true;
                $invoice->setSinrespuesta(true);
                $invoice->setMensajeError($resp);
                $em->persist($invoice);
                $em->flush();

            } else {
                if ($resp->autorizado) {
                    //$this->addTranslatedMessage('Comprobante autorizado, fecha: ' . $resp->fecha);
                    $respuesta = $resp->fecha;
                    $invoice->setAutorizado(true);
                    $invoice->setSinrespuesta(false);
                    $invoice->setMensajeError("");
                    $invoice->setFechaAutorizacion($resp->fecha);
                    $invoice->setXmlAutorizado($resp->comprobante);
                    $invoice->setStatus(Invoice::CLOSED);
                    $invoice->setForcefullyClosed(true);
                    $em->persist($invoice);
                    $em->flush();

                } else {
                    $error = true;
                    $respuesta = $resp;

                }
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }

        return $respuesta;
    }

    protected function generarXml(Invoice $invoice, &$error)
    {
        $error = false;
        $respuesta = null;
        try {
            $empresa = $invoice->getEmpresa();

            $serie = $invoice->getSerie();

            $numero = str_pad($invoice->getNumber(), 9, "0", STR_PAD_LEFT);

            $emisor = new Comprobante(null, $empresa, $serie);

            $resp = $emisor->generaClave($invoice->getIssueDate()->format('d/m/Y'), "01", $numero);

            if ($resp !== null) {
                //$this->addTranslatedMessage($resp, 'danger');
                $error = true;
                return $resp;
            }

            $invoice->setClaveAcceso($emisor->getClaveAcceso());

            $error = false;
            $factura = $emisor->generarXml($invoice, $error);

            if ($error) {
                //$this->addTranslatedMessage($factura, 'danger');
                return $factura;
            }

            try {
                $serializer = SerializerBuilder::create()->build();
                $xml = $serializer->serialize($factura, 'xml');
                $xml = trim(preg_replace('/\s+/', ' ', $xml));
                $invoice->setXml($xml);
            } catch (Exception $e) {
                //$this->addTranslatedMessage($e->getMessage(), 'danger');
                $error = true;
                return $e->getMessage();
            }

            $em = $this->getDoctrine()->getManager();
            $em->persist($invoice);
            $em->flush();

        } catch (Exception $e) {
            //$this->addTranslatedMessage($e->getMessage(), 'danger');
            //return null;
            $error = true;
            return $e->getMessage();
        }

        return $invoice;
    }

    protected function cargarImpuestos(AbstractInvoice $invoice)
    {
        $basecero = 0;
        $baseiva = 0;
        $valiva = 0;
        $base_iva5 = 0;

        foreach ($invoice->getItems() as $item) {

            $iva = 0;
            $p = $item->getProduct();

            //$item = new Item();
            if ($item->getDiscount() * 1 >= 100)
                $item->setDiscount($item->getDiscountPercent());

            $item->setNeto($item->getNetAmount());
            $item->setValdescuento($item->getDiscountAmount());

            $subtotal = $item->getQuantity() * $item->getUnitaryCost();

            if ($item->getTaxes() != null) {

                $tax = $item->getTaxes();
                //foreach ($postItem['taxes'] as $taxId) {
                //$tax = $taxRepo->find($taxId);
                //$tax = new Tax();
                if ($tax != null) {
                    $porcentaje = (double)$tax->getValue();
                    if ($porcentaje > 0) {
                        if($porcentaje == 5 || $porcentaje == 5.00){
                            $iva = $item->getNeto() * ($porcentaje / 100);

                            //$baseiva += $subtotal;
                            $base_iva5 += $item->getNeto();
                            $valiva += $iva;

                            $item->setValiva($iva);
                            $item->addTax($tax);
                            $item->setSubtotal($subtotal);
                            $invoice->setPorIva($tax->getValue());
                        }
                        else {
                            $iva = $item->getNeto() * ($porcentaje / 100);

                            //$baseiva += $subtotal;
                            $baseiva += $item->getNeto();
                            $valiva += $iva;

                            $item->setValiva($iva);
                            $item->addTax($tax);
                            $item->setSubtotal($subtotal);
                            $invoice->setPorIva($tax->getValue());
                        }
                    } else {
                        $basecero += $item->getNeto();

                        $item->setValiva(0);
                        $item->addTax($tax);
                        $item->setSubtotal($subtotal);
                        //$invoice->setPorIva($tax->getValue());
                    }
                }
            }


            //$item->addTax($tax);
            //}
            /*} else {
                $basecero += $subtotal;

                $item->setSubtotal($subtotal);
                $item->setValIva($iva);
            }
            */
        }

        $invoice->setTotalFactura($basecero + $baseiva + $valiva);
        $invoice->setBasecero($basecero);
        $invoice->setBaseiva($baseiva);

        $invoice->setBaseIva5($base_iva5);
    }

    protected function cleanParametro($valor)
    {
        $condition = preg_replace('/[^A-Za-z0-9\- ]/', '', $valor);
        $condition = trim($condition);
        //$condition = str_replace(" ", "%", $condition);

        //$aux = str_replace(array("'", "\"", "'", '"'), array("'", "&quot;\"'", "&quot;", $condition));

        return $condition;
    }
}
