<?php

namespace App\Controller\Admin;

use App\Entity\Model\Customer;
use App\Entity\Model\Invoice;
use App\Entity\Model\Item;
use App\Entity\Model\ItemPago;
use App\Entity\Model\Planes;
use App\Entity\Model\Property;
use App\Service\EmFactory;
use App\Util\RestApiFunciones;
use JMS\Serializer\Exception\Exception;
use Knp\Component\Pager\PaginatorInterface;
use Mobile_Detect;
use PDO;
use PDOException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Contracts\Translation\TranslatorInterface;

/**
 * @Route("/svadmin/config/param")
 */
class AdminParamController extends AbstractController
{

    protected $translator;

    /**
     * @Route("", name="admin_parametros_index")
     *
     */
    public function indexAction(Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $this->getDoctrine()->getManager('default');
        $repo = $em->getRepository('App\Entity\Model\Property');
        $parametros = $repo->findAll();

        $rutalogo = "";
        $paramlogoportada = null ;
        $keylogoportada=-1;

        foreach ($parametros as $key => $param) {
            if (strcmp(trim($param->getName()), 'logoportada') == 0) {
                $rutalogo = $param->getValue();
                if (file_exists(getcwd() . DIRECTORY_SEPARATOR. $rutalogo)) {
                    $imagen = file_get_contents(getcwd() .DIRECTORY_SEPARATOR. $rutalogo);
                    $logo = base64_encode($imagen);
                    $rutalogo = 'data: image/png;base64,' . $logo;
                }
                $paramlogoportada = $param;
                $keylogoportada = $key;
                break;
            }
        }

        $paramcuentatransferencia = null ;
        $detcuentatransfer="";
        $keycuentatransfer = -1;
        foreach ($parametros as $key => $param) {
            if (strcmp(trim($param->getName()), 'datos_cuenta_transferencia') == 0) {
                $paramcuentatransferencia = $param;
                $detcuentatransfer = $param->getValue();
                $keycuentatransfer = $key;
                break;
            }
        }

        if($keylogoportada > -1)
            unset($parametros[$keylogoportada]);

        if($keycuentatransfer > -1)
            unset($parametros[$keycuentatransfer]);

        $data['logoportada'] = "";
        $data['detcuentatransfer'] = $detcuentatransfer;
        $data['parametros'] = $parametros;
        $form = $this->createForm('App\Form\Admin\ParametroType', $data);

        if ($request->getMethod() === 'POST') {
            $form->handleRequest($request);
            if ($form->isSubmitted() && $form->isValid()) {
                $formData = $form->getData();
                if (!empty($formData['logoportada'])) {
                    /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                    $file = $formData['logoportada'];

                    $rutalogoportada = $this->saveLogo($file);

                    if ($rutalogoportada != null) {
                        $formData['logoportada'] = $rutalogoportada;
                        $paramlogoportada->setValue($rutalogoportada);
                        $em->persist($paramlogoportada);
                    }
                }
                if (!empty($formData['detcuentatransfer'])) {
                    $paramcuentatransferencia->setValue($formData['detcuentatransfer']);
                    $em->persist($paramcuentatransferencia);
                }

                foreach ($formData['parametros'] as $param) {
                    $em->persist($param);
                }
                $this->get('session')
                    ->getFlashBag()
                    ->add('success', $translator->trans('flash.updated', [], 'config'));
                $em->flush();
            }
        }

        return $this->render('Admin\Param\index.html.twig',
            array(
                'form' => $form->createView(),
                'rutalogo' => $rutalogo
                //   'search_form' => $form->createView(),
            ));
    }

    /**
     * @Route("/new", name="admin_plan_add")
     *
     */
    public function newAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $plan = new Planes();

        $form = $this->createForm('App\Form\PlanType', $plan, [
            'action' => $this->generateUrl('admin_plan_add'),
        ]);

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            if ($plan->getIlimitado()) {
                $aux = $em->getRepository('App\Entity\Model\Planes')->findByIlimitado();

                if ($aux) {
                    $this->addTranslatedMessage('Ya existe un plan ilimitado registrado', 'danger');
                } else {
                    $em->persist($plan);
                    $em->flush();
                    $this->addTranslatedMessage('Plan Insertado');

                    return $this->redirect($this->generateUrl('admin_plan_index'));
                }
            } else {
                $em->persist($plan);
                $em->flush();
                $this->addTranslatedMessage('Plan Insertado');

                return $this->redirect($this->generateUrl('admin_plan_index'));
            }

        }
        return $this->render('Admin\Plan\edit.html.twig',
            array(
                'form' => $form->createView(),
                'entity' => $plan,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => 'USD',
            ));
    }


    /**
     * @Route("/edit/plan{id}", name="admin_plan_edit")
     *
     */
    public function editAction($id, EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $entity = $em->getRepository('App\Entity\Model\Planes')->findById($id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Plan entity.');
        }

        $form = $this->createForm('App\Form\PlanType', $entity, [
            'action' => $this->generateUrl('admin_plan_edit', array('id' => $id)),
        ]);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {

            if ($request->request->has('Form-delete')) {

                $em->remove($entity);
                $em->flush();
                $this->addTranslatedMessage('Plan eliminado');

                return $this->redirect($this->generateUrl('admin_plan_index'));
            }
            if ($form->isValid()) {
                $redirectRoute = 'admin_plan_edit';

                if ($entity->getIlimitado()) {
                    $aux = $em->getRepository('App\Entity\Model\Planes')->findByIlimitadEdit($entity->getId());
                    if ($aux) {
                        $this->addTranslatedMessage('Ya existe un plan ilimitado registrado', 'danger');
                    } else {
                        $em->persist($entity);
                        $em->flush();
                        $this->addTranslatedMessage('Plan actualizado');

                        return $this->redirect($this->generateUrl($redirectRoute, array('id' => $id)));
                    }
                } else {

                    // Save.
                    $em->persist($entity);
                    $em->flush();
                    $this->addTranslatedMessage('Plan Actualizado');
                    return $this->redirect($this->generateUrl($redirectRoute, array('id' => $id)));
                }
            }
        }

        return $this->render('Admin\Plan\edit.html.twig',
            array(
                'entity' => $entity,
                'form' => $form->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => 'USD',
            ));
    }

    protected function addTranslatedMessage($message, $status = 'success')
    {
        $this->get('session')
            ->getFlashBag()
            ->add($status, $this->translator->trans($message, [], 'invoice'));
    }

    protected function saveLogo(UploadedFile $file)
    {
        $rutaLogo = null;
        try {
            //$path = $this->getParameter('ruta_documentos');

            if (empty($file)) {
                $this->addTranslatedMessage('Archivo logo no existe', 'warning');
                return null;
            }
            $ext = $file->guessExtension();
            // Move the file to the uploads directory.
            $uploadsDir = "portada" . DIRECTORY_SEPARATOR;

            if (!file_exists($uploadsDir)) {
                mkdir($uploadsDir, 0755, true);
            }

            $fileName = "logo." . $ext;

            $newFile = $file->move($uploadsDir, $fileName);
            //file_put_contents($uploadsDir."logo_portada.txt", DIRECTORY_SEPARATOR.'portada'.DIRECTORY_SEPARATOR.$fileName);
            // Update the property to the new file name.
            $rutaLogo = $uploadsDir . $fileName;
        } catch (\Exception $e) {
            $this->addTranslatedMessage($e->getMessage(), 'danger');
        }
        return $rutaLogo;
    }
}
