<?php

namespace App\Controller\Admin;

use App\Entity\Model\Customer;
use App\Entity\Model\Empresa;
use App\Entity\Model\Invoice;
use App\Entity\Model\Item;
use App\Entity\Model\ItemPago;
use App\Service\EmFactory;
use App\Util\RestApiFunciones;
use Doctrine\Persistence\ManagerRegistry;
use Knp\Component\Pager\PaginatorInterface;
use Mobile_Detect;
use PDO;
use PDOException;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Config\Definition\Exception\Exception;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Contracts\Translation\TranslatorInterface;

/**
 * @Route("/svadmin/cli")
 */
class AdminClientesController extends AbstractController
{

    protected $translator;

    /**
     * @Route("", name="admin_cli_index")
     *
     */
    public function indexAction(EmFactory $emFactory, Request $request, PaginatorInterface $paginator, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresaRepo->setPaginator($paginator);

        $limit = 200;

        $formSearch = $this->createForm('App\Form\Admin\SearchEmpresasType', null, [
            'action' => $this->generateUrl('admin_cli_index'),
            'method' => 'GET',
        ]);

        $formSearch->handleRequest($request);
        if ($formSearch->isSubmitted() && $formSearch->isValid()) {
            $emisor = $empresaRepo->paginatedSearch($formSearch->getData(), $limit, $request->query->getInt('page', 1));
        } else {
            $emisor = $empresaRepo->paginatedSearch([], $limit, $request->query->getInt('page', 1));
        }

        //$emisor = $empresaRepo->findAll();

        $repo = $em->getRepository('App\Entity\Model\Comprobantes');

        $comprobantes = array();
        foreach ($emisor as $item){

            //$item = new Empresa();
            $total = 0;
            $comprobante = array();
            $comprobante['emisor_id'] = $item->getId();
            $comprobante['razonsocial'] = $item->getRazonSocial();
            $comprobante['ruc'] = $item->getRuc();
            $comprobante['plan'] = $item->getPlan() === null ? '' : $item->getPlan();

            $comprobante['fcreacion'] =  $item->getCreateDate() === null ? '': $item->getCreateDate()->format('d/M/Y');
            $comprobante['fcaduca'] =  $item->getFechaCaduca() === null ? '': $item->getFechaCaduca()->format('d/M/Y');

            $facturas = $repo->countInvoiceEmitidos($item->getId());
            if($facturas) {
                $comprobante['facturas'] = $facturas;
                $total += $facturas;
            }

            $retenciones = $repo->countRetencionesEmitidos($item->getId());
            if($retenciones) {
                $comprobante['retenciones'] = $retenciones;
                $total += $retenciones;
            }

            $liquidaciones = $repo->countLiquidacionEmitidos($item->getId());
            if($liquidaciones) {
                $comprobante['liquidaciones'] = $liquidaciones;
                $total += $liquidaciones;
            }

            $ncreditos = $repo->countNcreditosEmitidos($item->getId());
            if($ncreditos){
                $comprobante['ncreditos'] = $ncreditos;
                $total += $ncreditos;
            }

            $guias = $repo->countGuiasEmitidos($item->getId());
            if($guias){
                $comprobante['guias'] = $guias;
                $total += $guias;
            }

            $comprobante['total'] = $total;

            $contratados = $item->getCmpContratados();

            $comprobante['contratado'] = $contratados;
            $disponible = $contratados - $total;

            $comprobante['estado'] = $disponible > 0 ? 'D': 'A';  // D = DISPONIBLE, A = AGOTADO

            if($item->getCmpContratados() > 0) {
                $comprobante['disponible'] = $disponible;
            }
            else {
                $comprobante['disponible'] = '';
                $comprobante['estado'] ='';
                $comprobante['contratado'] ='';
            }


            $comprobantes[]= $comprobante;

            /*
            //////
            ///
            //$item = new Empresa();
            $aux = $repo->firstProduccion(Invoice::class, $item->getId());
            if($aux){
                $x = $aux[0]['createdAt']->format('Y/M/d');
                $item->setFechaInicio($aux[0]['createdAt']);
                $em->persist($item);
            }
            else{
                $aux = $repo->firstProduccion(Retencion::class, $item->getId());
                if($aux){
                    $x = $aux[0]['createdAt']->format('Y/M/d');
                    $item->setFechaInicio($aux[0]['createdAt']);
                    $em->persist($item);
                }
            }
            */

            //////

        }

        $em->flush();

        return $this->render('Admin\CLI\index.html.twig',
            array(
                'invoices' => $comprobantes,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => 'USD',
                'search_form' => $formSearch->createView(),
                //'list_form' => $listForm->createView(),
            ));
    }

    /**
     * @Route("/show/{slug}cli{id}", name="admin_cliente_show")
     *
     */
    public function clienteShowAction($id, EmFactory $emFactory, $slug, TranslatorInterface $translator, Request $request, LoggerInterface $logger,  ManagerRegistry $doctrine)
    {
        $this->logger = $logger;
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $emdefault = $doctrine->getManager('default');
        $parambase = $emdefault->getConnection()->getParams();
        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $emisor = $empresaRepo->findOneById($id);

        $planori = 0;
        $pagoori = null;
        if($emisor->getPlan())
            $planori = $emisor->getPlan()->getId();

        if($emisor->getRutaPago())
            $pagoori = $emisor->getRutaPago();

        if (!$emisor) {
            throw $this->createNotFoundException('Unable to find Emisor entity.');
        }

        if($emisor->getPlan())
            $emisor->setPlan($emisor->getPlan()->getId());

        $planesRepo = $em->getRepository('App\Entity\Model\Planes');
        $planes = $planesRepo->findAll();

        $plan = [];
        foreach ($planes as $item){
            $plan[strtoupper($item->getName())]=$item->getId() ;
        }

        //$form = $this->createForm(ClienteType::class, $emisor);

        $imgpago = null;
        if ($request->getMethod() === 'GET') {
            if ($emisor->getRutaPago()) {
                try {
                    $pathPago = $_SERVER['DOCUMENT_ROOT']. DIRECTORY_SEPARATOR. $emisor->getRutaPago();

                    $imagen = file_get_contents($pathPago);
                    $pago = base64_encode($imagen);
                    if ($pago !== null)
                        //$data['logo'] = 'data: '.mime_content_type($image).';base64,'.$imageData;
                        $imgpago = 'data: image/png;base64,' . $pago;
                }
                catch (\Exception $ex){

                }
            }

        }
        $emisor->setRutaPago(null);

        $form = $this->createForm('App\Form\Admin\ClienteType', $emisor, [
            'planes' => $plan,
        ]);

        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            // data is an array with "name", "email", and "message" keys
            //$data = $form->getData();
            //$emisor->setEnabled($data["enabled"] === null ? true : $data["enabled"]);
            $formData = $form->getData();
            if (!empty($emisor->getRutaPago())) {
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $emisor->getRutaPago();

                $rutaPago = $this->savePago($file, $emisor->getRuc(), $logger);

                if ($rutaPago != null) {
                    $emisor->setRutaPago($rutaPago);
                }
            } else {
                // Unset the key otherwise the previous logo will be deleted.
                if ($pagoori)
                    $emisor->setRutaPago($pagoori);

            }

            $repo = $em->getRepository('App\Entity\Model\Planes');
            $plan = $repo->findById($emisor->getPlan());

            $emisor->setPlan($plan);

            if($planori > 0){
                if($planori !== $plan->getId())
                    $emisor->setCmpContratados(-1);
            }

            /*if ($emisor->getTipoAmbiente() === "2") {
                $emisor->setFechaInicio(new \DateTime());

                if ($plan) {

                    if ($emisor->getFechaCaduca() === null)
                        $contratados = 0;
                    else
                        $contratados = $emisor->getCmpContratados() === null ? 0 : $emisor->getCmpContratados();

                    $dias_pago = $plan->getDiasPago();
                    $fechaActual = new \DateTime();
                    $fechaActual->add(new \DateInterval('P' . $dias_pago . 'D'));
                    $emisor->setFechaCaduca($fechaActual);

                    $ncomprobantes = $plan->getNumFacMes();

                    if ($contratados === -1)
                        $contratados = 0;

                    $emisor->setCmpContratados($ncomprobantes + $contratados);
                }

            }*/

            $em->persist($emisor);
            $em->flush();
            $this->addTranslatedMessage('Registro Actualizado');

            return $this->redirect($this->generateUrl('admin_cliente_show', array('slug' => $id, 'id' => $id)));
        }

        return $this->render('Admin\CLI\show.html.twig',
            array(
                'entity' => $emisor,
                'form' => $form->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $emisor == null ? 'USD' : $emisor->getCurrency(),
                'imgpago' => $imgpago
            ));
    }

    /**
     * @Route("/show/{slug}inv{id}", name="admin_fa_show")
     *
     */
    public function showAction($id, EmFactory $emFactory, $slug, TranslatorInterface $translator, Request $request, LoggerInterface $logger)
    {
        $this->logger = $logger;
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $emisor = $empresaRepo->findOneByUser($user->getRuc());

        $entity = $em->getRepository('App\Entity\Model\Invoice')->findBySlug($slug, $id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Invoice entity.');
        }

        $defaultData = ['slug' => $slug, 'id'=>$id, 'customerEmail' => $entity->getCustomerEmail()];

        $form = $this->createFormBuilder($defaultData)
            ->add('slug', HiddenType::class)
            ->add('id', HiddenType::class)
            ->add('customerEmail')
            ->setAction($this->generateUrl('invoice_show', ['id' => $id, 'slug'=>$slug]))
            ->getForm();

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // data is an array with "name", "email", and "message" keys
            $data = $form->getData();

            if ($request->request->has('Form-pdf')) {
                $this->generarPdf($entity);
            } elseif ($request->request->has('Form-email')) {
                if (isset($data['customerEmail'])) {
                    $email = $data['customerEmail'];
                    $this->enviarMail($email, $entity);
                } else
                    $this->addTranslatedMessage('Email del cliente nulo o en blanco', 'warning');
            } elseif ($request->request->has('Form-edit')) {
                if ($entity->getAutorizado() === false)
                    return $this->redirect($this->generateUrl('invoice_edit', ['id' => $entity->getId(), 'slug' => $slug]));
            } elseif ($request->request->has('Form-delete')) {
                $error = $this->delete($entity);
                if ($error)
                    return $this->redirect($this->generateUrl('invoice_index'));
            } elseif ($request->request->has('Form-anular')) {
                $entity->setAnulado(true);
                $em->persist($entity);
                $em->flush();
            } elseif ($request->request->has('Form-enviar')) {
                $this->enviarSriOnline($entity);
            } elseif ($request->request->has('Form-auto')) {
                if ($entity->getAutorizado() === false) {
                    $resp = $this->consultarAutorizacion($entity);
                    if ($resp != null)
                        $this->addTranslatedMessage($resp, 'danger');
                }

            }
        }

        if ($entity->getMensajeError()) {
            $this->addTranslatedMessage($entity->getMensajeError(), 'danger');
        }

        /*if (!$entity->isClosed()) {
            // When the invoice is open send to the edit form by default.
            return $this->redirect($this->generateUrl('invoice_edit', array('id' => $id)));
        }
        */

        return $this->render('Invoice\show.html.twig',
            array(
                'entity' => $entity,
                'form' => $form->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $emisor == null ? 'USD' : $emisor->getCurrency(),
            ));
    }

    /**
     * @Route("/new", name="invoice_add")
     *
     */
    public function newAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        //require_once "Mobile_Detect.php";
        $detect = new Mobile_Detect;


        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        // Check for mobile environment.
        $movil = false;
        if ($detect->isMobile()) {
            // Your code here.
            $movil = true;
        }

        $invoice = new Invoice();
        $newItem = new Item();

        $tax = $em->getRepository('App\Entity\Model\Tax')->findTaxDefault($empresa->getId());
        $newItem->setTaxes($tax);
        $invoice->addItem($newItem);

        $itemPago = new ItemPago();
        $itemPago->setPlazo(0);
        $invoice->addPago($itemPago);

        /*if ($request->isMethod('GET') || $request->isMethod('get')) {
            $consfinal = $em->getRepository('App\Entity\Model\Customer')->findConsumidorFinal($empresa->getId());
            if ($consfinal) {
                //$consfinal = new Customer();
                $invoice->setCustomer($consfinal);
                $invoice->setCustomerIdentification($consfinal->getIdentification());
                $invoice->setCustomerName($consfinal->getName());
                $invoice->setInvoicingAddress($consfinal->getInvoicingAddress());
                $invoice->setCustomerEmail($consfinal->getEmail());
            }
        }*/

        $form = $this->createForm('App\Form\InvoiceType', $invoice, [
            'action' => $this->generateUrl('invoice_add'),
        ]);

        /*if ($request->isMethod('POST')) {

            $taxRepo = $em->getRepository('SiwappCoreBundle:Tax');

            $all = $request->request->all();

            $aux= $all['invoice']['items'];
            if ( $aux != null) {

                foreach ($aux as $clave=>$Item) {
                    if ($Item['taxes'] == "S") {
                        $tax = $taxRepo->find(1);
                        if (!$tax) {
                            continue;
                        }
                        $Item['taxes'] = array(1);
                    } else {
                        $tax = $taxRepo->find(2);
                        if (!$tax) {
                            continue;
                        }
                        $Item['taxes'] = array(2);
                    }
                    $aux[$clave]= $Item;

                }

                $all['invoice']['items'] = $aux;
                $request->request->replace($all);
            }
            $form->handleRequest($request);
        }
        else*/

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            if ($request->request->has('save_draft')) {
                $invoice->setStatus(Invoice::DRAFT);
            } else {
                // Any save action transforms this to opened.
                $invoice->setStatus(Invoice::OPENED);
            }

            //if ($invoice->getCustomer() == null && $invoice->getCustomerIdentification() != '9999999999999') {
            //    $this->addTranslatedMessage('Cliente no se encuentra registrado', 'danger');
            //} else {
                //$invoice->setNumber(null);
                $serie = $invoice->getSeries()->getValue();
                $invoice->setSerie($serie);
                $this->cargarImpuestos($invoice);
                $invoice->setEmpresa($empresa);
                $invoice->setUsuario($user->getId());
                $invoice->setAmbiente($empresa->getTipoAmbiente());

                $em->persist($invoice);
                $em->flush();
                //$this->addTranslatedMessage('flash.added');

                $invoice_id = $invoice->getId();

                $invoice = $this->generarXml($invoice);

                if ($empresa->getEnvioAutomatico()) {

                    if ($invoice !== null) {
                        $app_url = $this->getParameter('cola_url');

                        $error = false;

                        $resp = RestApiFunciones::enviarComprobanteCola($error,
                            $invoice->getCustomerName(),
                            $invoice->getCustomerEmail(),
                            $user->getId(),
                            $invoice->getXml(),
                            $invoice->getClaveAcceso(),
                            $app_url,
                            'invoice'
                        );

                        if ($error) {
                            $this->addTranslatedMessage($resp, 'danger');
                            $invoice->setMensajeError($resp);
                        }

                        $em->persist($invoice);
                        $em->flush();

                    }

                    return $this->redirect($this->generateUrl('invoice_index'));

                }
                return $this->redirect($this->generateUrl('invoice_show', ['id' => $invoice_id, 'slug' => $invoice->getSlug()]));
            //}
        }

        $customer = new Customer();

        $formcustomer = $this->createForm('App\Form\CustomerType', $customer, [
            'action' => $this->generateUrl('rest_customer_add'),
        ]);
        $formcustomer->handleRequest($request);

        return $this->render('Invoice\edit.html.twig',
            array(
                'form' => $form->createView(),
                'movil' => $movil,
                'formcustomer' => $formcustomer->createView(),
                'customer' => $customer,
                'entity' => $invoice,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $empresa == null ? 'USD' : $empresa->getCurrency(),
            ));
    }


    /**
     * @Route("/edit/{slug}inv{id}", name="invoice_edit")
     *
     */
    public function editAction($id, EmFactory $emFactory, Request $request, $slug, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $entity = $em->getRepository('App\Entity\Model\Invoice')->findBySlug($slug, $id);
        if (!$entity && $entity->getEmpresa() != $empresa) {
            throw $this->createNotFoundException('Unable to find Invoice entity.');
        }

        if($entity->getAutorizado()){
            return $this->redirect($this->generateUrl('invoice_show', ['id' => $id, 'slug' => $slug]));
        }

        $form = $this->createForm('App\Form\InvoiceType', $entity, [
            'action' => $this->generateUrl('invoice_edit', ['id' => $id, 'slug' => $slug]),
        ]);
        $form->handleRequest($request);

        $entity->setEmpresa($empresa);

        if ($form->isSubmitted() && $form->isValid()) {
            $redirectRoute = 'invoice_show';

            $serie = $entity->getSeries()->getValue();
            $entity->setSerie($serie);
            $entity->setUsuario($user->getId());
            $this->cargarImpuestos($entity);

            if ($request->request->has('save_draft')) {
                $entity->setStatus(Invoice::DRAFT);
            } elseif ($request->request->has('save_close')) {
                $entity->setForcefullyClosed(true);
            } elseif ($entity->isDraft()) {
                // Any save action transforms this to opened.
                $entity->setStatus(Invoice::OPENED);
            }

            /*
            // See if one of PDF/Print buttons was clicked.
            if ($request->request->has('save_pdf')) {
                $redirectRoute = 'invoice_show_pdf';
            } elseif ($request->request->has('save_print')) {
                $this->get('session')->set('invoice_auto_print', $id);
            }

            */

            // Save.
            $em->persist($entity);
            $em->flush();
            //$this->addTranslatedMessage('flash.updated');

            $entity = $this->generarXml($entity);

            return $this->redirect($this->generateUrl($redirectRoute, ['id' => $id, 'slug' => $slug]));
        }

        return $this->render('Invoice\edit.html.twig',
            array(
                'entity' => $entity,
                'form' => $form->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $empresa == null ? 'USD' : $empresa->getCurrency(),
            ));
    }

    public function enviarSriOnline(Invoice $invoice)
    {
        $invoice = $this->generarXml($invoice);
        $em = $this->getDoctrine()->getManager();

        if($invoice !== null) {
            $app_url = $this->getParameter('api_url');

            $error = false;
            $resp = RestApiFunciones::enviarComprobante($error, $invoice->getXml(), $invoice->getClaveAcceso(), $app_url);

            if ($error)
                $this->addTranslatedMessage($resp->message, 'danger');
            else {
                if ($resp->estado === 'recibido') {
                    $resp = $this->consultarAutorizacion($invoice);

                    if ($resp !== null)
                        $this->addTranslatedMessage($resp, 'danger');
                } else {
                    $invoice->setMensajeError($resp->message);
                    $this->addTranslatedMessage($resp->message, 'danger');
                    $em->persist($invoice);
                    $em->flush();
                }
            }

        }
    }

    /**
     * @Route("/payments/{slug}inv{id}", name="invoice_payments")
     *
     */
    public function paymentsAction(Request $request, $slug, EmFactory $emFactory, TranslatorInterface $translator)
    {
        $this->translator = $translator;

        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        // Return all payments
        $invoice = $em->getRepository('App\Entity\Model\Invoice')->findBySlug($slug);
        if (!$invoice) {
            throw $this->createNotFoundException('Unable to find Invoice entity.');
        }

        $payment = new Payment;
        $addForm = $this->createForm('App\Form\PaymentType', $payment, [
            'action' => $this->generateUrl('invoice_payments', ['id' => $invoice->getId(), 'slug' => $slug]),
        ]);
        $addForm->handleRequest($request);
        if ($addForm->isSubmitted() && $addForm->isValid()) {
            $invoice->addPayment($payment);
            $em->persist($invoice);
            $em->flush();
            $this->addTranslatedMessage('payment.flash.added');

            // Rebuild the query, since we have new objects now.
            return $this->redirect($this->generateUrl('invoice_index'));
        }

        $listForm = $this->createForm('App\Form\ListInvoicePaymentType', $invoice->getPayments()->getValues(), [
            'action' => $this->generateUrl('invoice_payments', ['id' => $invoice->getId(), 'slug' => $slug]),
        ]);
        $listForm->handleRequest($request);

        if ($listForm->isSubmitted() && $listForm->isValid()) {
            $data = $listForm->getData();
            foreach ($data['payments'] as $payment) {
                $invoice->removePayment($payment);
                $em->persist($invoice);
                $em->flush();
            }
            $this->addTranslatedMessage('payment.flash.bulk_deleted');

            // Rebuild the query, since some objects are now missing.
            return $this->redirect($this->generateUrl('invoice_index'));
        }

        return $this->render('Payment\list.html.twig',
            [
                'invoiceId' => $invoiceId,
                'add_form' => $addForm->createView(),
                'list_form' => $listForm->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $emisor == null ? 'USD' : $emisor->getCurrency(),
            ]);
    }

    /**
     * @Route("/form-totals", name="invoice_form_totals")
     */
    public function getInvoiceFormTotals(EmFactory $emFactory, Request $request)
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $post = $request->request->get('invoice');
        if (!$post) {
            throw new NotFoundHttpException;
        }

        $response = $this->getInvoiceTotalsFromPost($post, new Invoice, $request->getLocale());

        return new JsonResponse($response);
    }

    /**
     * @Route("/pdfpreview/{slug}inv{id}", name="invoice_show_pdf_preview")
     *
     */
    public function showOnlinePdfAction($id,  $slug, EmFactory $emFactory, TranslatorInterface $translator, Request $request, LoggerInterface $logger)
    {
        $this->logger = $logger;
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $invoice = $em->getRepository('App\Entity\Model\Invoice')->findBySlug($slug, $id);
        if (!$invoice) {
            throw $this->createNotFoundException('Unable to find Invoice entity.');
        }

        $filename = 'FAC_' . $invoice->getSerie() . "-" . str_pad($invoice->getNumber(), 9, '0', STR_PAD_LEFT) . '.pdf';

        if ($invoice->getAutorizado())
            $xml = $invoice->getXmlAutorizado();
        else
            $xml = $invoice->getXml();

        $app_url = $this->getParameter('api_url').'facturaride.php';

        $error = false;
        $mensaje = "";

        $docPdf = RestApiFunciones::getPdf($error, $app_url, $invoice->getClaveAcceso(), $xml, $mensaje, null);

        if ($error) {
            $this->addTranslatedMessage('ERRROR AL GENERAR EL PDF, ' . $mensaje, 'danger');
        } else {
            file_put_contents($filename, $docPdf);

            $pdf = base64_encode(file_get_contents($filename));

            $response = new Response($pdf);
            $response->headers->set('Content-Type', 'application/octet-stream');
            $response->headers->set('Content-Description', 'File Transfer');
            $response->headers->set('Content-Disposition', 'attachment; filename="'.$filename.'"');
            // $response->headers->set('Expires', '0');
            // $response->headers->set('Content-Transfer-Encoding', 'binary');
            $response->headers->set('Content-length', strlen($pdf));
            $response->headers->set('Cache-Control', 'no-cache private');
            // $response->headers->set('Pragma', 'public');
            // Send headers before outputting anything
            $response->sendHeaders();



            try {
                unlink($filename);
            } catch (\Exception $ex) {

            }
            return $response;
        }
    }

    protected function bulkAutorizar(array $invoices)
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');

        $em = $this->getDoctrine()->getManager();

        foreach ($invoices as $invoice) {
            if($invoice !== null) {
                $app_url = $this->getParameter('api_url');

                $error = false;
                $resp = RestApiFunciones::enviarComprobante($error, $invoice->getXml(), $invoice->getClaveAcceso(), $app_url);

                if ($error)
                    $this->addTranslatedMessage($resp->message, 'danger');
                else {
                    if ($resp->estado === 'recibido') {
                        $resp = $this->consultarAutorizacion($invoice);

                        if ($resp !== null)
                            $this->addTranslatedMessage($resp, 'danger');
                    } else {
                        $invoice->setMensajeError($resp->message);
                        $this->addTranslatedMessage($resp->message, 'danger');
                        $em->persist($invoice);
                        $em->flush();
                    }
                }

            }
        }

        //return $this->redirect($this->generateUrl('admin_cmp_index'));
    }

    protected function consultarAutorizacion(Invoice $invoice)
    {
        $respuesta = null;
        try {
            $em = $this->getDoctrine()->getManager();

            $app_url = $this->getParameter('api_url');

            $error = false;

            $resp = RestApiFunciones::consultarAutoComprobante($error, $app_url, $invoice->getClaveAcceso());

            if ($error) {
                $this->addTranslatedMessage($resp, 'danger');
                $invoice->setSinrespuesta(true);
                $invoice->setMensajeError($resp);
                $em->persist($invoice);
                $em->flush();

            } else {
                if ($resp->autorizado) {
                    $this->addTranslatedMessage('Comprobante autorizado, fecha: ' . $resp->fecha);
                    $invoice->setAutorizado(true);
                    $invoice->setSinrespuesta(false);
                    $invoice->setMensajeError("");
                    $invoice->setFechaAutorizacion($resp->fecha);
                    $invoice->setXmlAutorizado($resp->comprobante);
                    $invoice->setStatus(Invoice::CLOSED);
                    $invoice->setForcefullyClosed(true);
                    $em->persist($invoice);
                    $em->flush();

                } else {
                    $this->addTranslatedMessage($resp, 'danger');
                }
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }

        return $respuesta;
    }

    protected function addTranslatedMessage($message, $status = 'success')
    {
        $this->get('session')
            ->getFlashBag()
            ->add($status, $this->translator->trans($message, [], 'invoice'));
    }

    protected function savePago(UploadedFile $file, $ruc, LoggerInterface $logger)
    {
        $rutaPago = null;
        try {
            //$path = $this->getParameter('ruta_documentos');

            if (empty($file)) {
                $this->addTranslatedMessage('Archivo pago no existe', 'warning');
                return null;
            }
            $ext = $file->guessExtension();
            // Move the file to the uploads directory.
            $uploadsDir = "temp/";

            if (!file_exists($uploadsDir)) {
                mkdir($uploadsDir, 0755, true);
            }

            $fileName = "pago_" . $ruc . "." . $ext;

            $newFile = $file->move($uploadsDir, $fileName);

            // Update the property to the new file name.
            $rutaPago = $uploadsDir . $fileName;
        } catch (\Exception $e) {
            $this->addTranslatedMessage($e->getMessage(), 'danger');
        }
        return $rutaPago;
    }
}
