<?php

namespace App\Repository;

use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\Tools\Pagination\Paginator;
use Knp\Component\Pager\PaginatorInterface;
use App\Entity\Model\Provider;

/**
 * ProviderRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ProviderRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * @var mixed|\Knp\Component\Pager\PaginatorInterface
     */
    public $paginator;

    public function findBySlug(string $slug, $id): ?Provider
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Provider::class, 'c')
                ->Where("c.slug = :slug")
                ->andWhere("c.id = :id")
                ->setParameter('slug', $slug)
                ->setParameter('id', $id)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $nonUniqueResultException) {
            return null;
        }
    }

    public function findLike($term, $empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Provider::class, 'c')
            ->where('c.name LIKE :name')
            ->andWhere('c.empresa = :empresa_id')
            ->orWhere('c.identification LIKE :name')
            ->setParameter('name', '%'. $term .'%')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public function paginatedSearch(array $params, $limit, $page, $empresa_id)
    {
        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Provider::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id);

        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }

            if ($field == 'terms') {
                $terms = $qb->expr()->literal(sprintf('%%%s%%', $value));
                $qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('c.name', $terms),
                    $qb->expr()->like('c.identification', $terms)
                ));
            }
        }

        //$qb->leftJoin('c.retencions', 'i');
        //$qb->addSelect('SUM(CASE WHEN i.gross_amount IS NULL THEN 0 ELSE i.gross_amount END) AS gross_amount');
        //$qb->addSelect('SUM(CASE WHEN i.gross_amount IS NULL THEN 0 ELSE i.gross_amount END - CASE WHEN i.paid_amount IS NULL THEN 0 ELSE i.paid_amount END) AS due_amount');
        $qb->groupBy('c.id');

        return $this->paginator->paginate($qb->getQuery(), $page, $limit);
    }

    /**
     * There is no easy way to inject things into repositories yet.
     */
    public function setPaginator(PaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }

    public function findIdentificacion($term, $empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Provider::class, 'c')
            ->Where('c.identification = :name')
            ->andWhere('c.empresa = :empresa')
            ->setParameter('name',  $term )
            ->setParameter('empresa',  $empresa_id )
            ->getQuery()
            ->getResult();
    }

    public function findConsumidorFinal($empresa_id)
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Provider::class, 'c')
                ->Where("c.identification = '9999999999999'")
                ->andWhere('c.empresa = :empresa')
                ->setParameter('empresa', $empresa_id)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $nonUniqueResultException) {
            return null;
        }
    }

    public function paginatedAjax(string $sql, $params, $limit, $page, $empresa_id)
    {
        $query = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('p')
            ->from(Provider::class, 'p')
            ->where('p.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->setFirstResult($page)
            ->setMaxResults($limit)
            ->orderBy('p.name');

        if ($params) {
            $terms = $query->expr()->literal(sprintf('%%%s%%', $params));
            $query->andWhere($query->expr()->orX(
                $query->expr()->like('p.identification', $terms),
                $query->expr()->like('p.name', $terms)
            ));
        }

        return  new Paginator($query, $fetchJoinCollection = true);

    }
}
