<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;

class SearchFacturaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('terms', null, [
                'required' => false,
                'label' => 'Texto a Buscar',
            ])
            ->add('status', ChoiceType::class, [
                'label' => 'Estado SRI',
                'choices' => [
                    'Generado' => 'G',
                    'Autorizado' => 'A',
                    'NO Autorizado' => 'R',
                ],
                'required' => false,
            ])
            ->add('date_from', DateType::class, [
                'label' => 'Fecha Desde',
                'widget' => 'single_text',
                'required' => false,
            ])
            ->add('date_to', DateType::class, [
                'label' => 'Hasta',
                'widget' => 'single_text',
                'required' => false,
            ])
            ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'csrf_protection' => false,
            'attr' => ['id' => 'forminvoicesearchsv']
        ]);
    }
}
