<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EmpresaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', null, [
                'label' => 'Apellidos/Nombres Razon Social',
                'attr' => ['class' => 'text-uppercase', 'autocomplete' => 'off']
            ])
            ->add('identification', null, [
                'label' => 'RUC/CI',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('email', null, [
                'label' => 'Email',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('contact_person', null, [
                'label' => 'Contacto',
                'attr' => ['autocomplete' => 'off'],
            ])

            ->add('tipoIdent', \Symfony\Component\Form\Extension\Core\Type\ChoiceType::class, ['label' => 'Tipo Identificacion', 'attr' => ['class' => 'form-control', 'autocomplete' => 'off'], 'label_attr' => ['class' => 'control-label'], 'choices' => ['RUC' => 'R', 'Cedula' => 'C', 'Pasaporte' => 'P'], 'required'    => true, 'placeholder' => 'Seleccione opcion', 'empty_data'  => null])

            ->add('telefono', null, [
                'label' => 'Telefono',
                'attr' => ['autocomplete' => 'off'],
            ])

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Empresa::class,
        ]);
    }
}
