<?php

namespace App\Form\Admin;

use App\Entity\Model\EmpresaContador;
use App\Entity\Model\ItemEmpresaContador;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EmpresasUsuarioType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $escontador = $options['escontador'];

        $builder
            ->add('razon_social', TextType::class, [
                'required' => true,
                'label' => 'form.company_name',
                'attr' => ['class'=>'sv_uppercase','readonly'=>'readonly'],
                'translation_domain' => 'config',
            ])
           /* ->add('ruc', TextType::class, [
                'required' => true,
                'attr' => ['readonly'=>'readonly'],
                'label' => 'form.company_identification',
                'translation_domain' => 'config',
            ])*/
            ->add('escontador', CheckboxType::class, [
                'required' => false,
                'label' => 'Contador',
                'data' => $escontador
            ]);


        $builder->add('items', CollectionType::class, array(
            'entry_type' => 'App\Form\Admin\ItemEmpresaContadorType',
            'allow_add' => true,
            'allow_delete' => true,
            'prototype' => true,
            'by_reference' => false,
            'label' => false,
            'prototype_data' => new ItemEmpresaContador(),
        ));

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\EmpresaContador',
            'attr' => ['id' => 'admin_usuarios_sv'],
            'escontador' => false,
        ]);
    }
}
