<?php

namespace App\Form;

use App\Entity\Model\AbstractRetencion;
use App\Entity\Model\Series;
use App\Service\EmFactory;
use App\Entity\Model\ItemRetencion;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;


class AbstractRetencionType extends AbstractType
{
    private $manager;

    private $security;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $series =  $this->manager->getRepository(\App\Entity\Model\Series::class)->findSeriesEmpresa($empresa->getId());

        $repo = $this->manager->getRepository(\App\Entity\Model\Retencion::class);
        $numero = 0;
        if ($repo && $series[0])
        {
            $numero = $repo->getNextNumber($series[0], $empresa->getId());
        }

        $builder
            ->add('number', null, [
                'label' => 'form.numero',
                'data' => str_pad($numero, 9, "0", STR_PAD_LEFT),
                'disabled' => true, //TODO PARA IGNORAR EL SUBMITTED
                'translation_domain' => 'retencion',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('provider_name', null, [
                'label' => 'form.provider_name',
                'required'=>true,
                'attr' => ['readonly'=>'readonly', 'autocomplete' => 'off'],
                'translation_domain' => 'retencion',
            ])

            ->add('provider_identification', null, [
                'label' => 'form.provider_identification',
                 'required' =>true,
                'translation_domain' => 'retencion',
                'attr' => ['autocomplete' => 'on'],
            ])

            ->add('provider_email', null, [
                'required'=>true,
                'attr' => ['readonly'=>'readonly', 'autocomplete' => 'off'],
                'label' => 'form.provider_email',
                'translation_domain' => 'retencion',
            ])
            ->add('provider_address', null, [
                'label' => 'form.provider_address',
                'attr' => ['readonly'=>'readonly', 'autocomplete' => 'off'],
                'translation_domain' => 'retencion',
            ])

            ->add('notes', null, [
                'attr' => ['class' => 'text-uppercase', 'autocomplete' => 'off'],
                'label' => 'form.notes',
                'translation_domain' => 'retencion',
            ])

        ;

        $builder->add('items', CollectionType::class, ['entry_type' => \App\Form\ItemRetencionType::class, 'allow_add' => true, 'allow_delete' => true, 'prototype' => true, 'by_reference' => false, 'label' => false, 'prototype_data' => new ItemRetencion()]);

        /*$builder->add('series', EntityType::class, array(
            'class' => 'App\Entity\Model\Series',
            'choice_label' => 'name',
            'label' => 'form.series',
            'translation_domain' => 'retencion',
        ));
        */


        $builder->add('series', EntityType::class, [
            'class' => Series::class,
            'choice_label' => 'value',
            'required' => true,
            //'placeholder' => 'Seleccione una serie ...',
            'label' => 'form.series',
            'translation_domain' => 'retencion',
            'choices' => $series,
            'attr' => ['readonly'=>'readonly', 'autocomplete' => 'off'],
        ]);

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => AbstractRetencion::class,
        ]);
    }
}
