<?php

namespace App\Form;

use App\Service\EmFactory;
use App\Entity\Model\Destinatario;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class AbstractGuiaRemisionType extends AbstractType
{
    private $manager;
    private $security;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $series =  $this->manager->getRepository('App\Entity\Model\Series')->findSeriesEmpresa($empresa->getId());

        $repo = $this->manager->getRepository('App\Entity\Model\GuiaRemision');
        $numero = 0;
        if ($repo && $series[0])
        {
            $numero = $repo->getNextNumber($series[0], $empresa->getId());
        }

        $builder
            ->add('number', TextType::class, [
                'label' => 'form.numero',
                'data' => str_pad($numero, 9, "0", STR_PAD_LEFT),
                'disabled' => true, //TODO PARA IGNORAR EL SUBMITTED
                'translation_domain' => 'invoice',
                'attr' => array('autocomplete' => 'off'),
            ])
            ->add('transportista_name', TextType::class, [
                'required'=>true,
                'attr' => ['autocomplete' => 'off','readonly'=>'readonly'],
                'label' => 'Transportista',
            ])
            ->add('transportista_identification', TextType::class, [
                'required' => true,
                'label' => 'form.customer_identification',
                'attr' => ['autocomplete' => 'on'],
                'translation_domain' => 'invoice',
            ])
            ->add('transportista_email', EmailType::class, [
                'required' => true,
                'attr' => ['readonly'=>'readonly', 'autocomplete' => 'off'],
                'label' => 'form.customer_email',
                'translation_domain' => 'invoice',
            ])
            ->add('transportista_placa', TextType::class, [
                'required' => true,
                'attr' => ['readonly'=>'readonly', 'autocomplete' => 'off'],
                'label' => 'Placa',
            ])
            ->add('direccionpPartida', TextType::class, [
                'attr' => ['rows' => 1, 'autocomplete' => 'off', 'maxlength'=>200],
                'label' => 'Dirección Partida',
            ])
            ->add('issue_date', DateType::class, [
                'widget' => 'single_text',
                'label' => 'form.issue_date',
                'translation_domain' => 'invoice',
                'attr' => ['autocomplete' => 'off'],
            ])

            ->add('fecini_transporte', DateType::class, [
                'widget' => 'single_text',
                'label' => 'Fecha Inicio Transporte',
                'attr' => ['autocomplete' => 'off'],
            ])

            ->add('fecfin_transporte', DateType::class, [
                'widget' => 'single_text',
                'label' => 'Fecha Fin Transporte',
                'attr' => ['autocomplete' => 'off'],
            ])

            ->add('notes', TextType::class, [
                'label' => 'form.notes',
                'attr' => ['class'=>'sv_uppercase', 'maxlength'=>200, 'autocomplete' => 'off'],
                'required' => false,
                'translation_domain' => 'invoice',
            ])
            ->add('note1', TextType::class, [
                'label' => 'form.observacion',
                'attr' => ['class'=>'sv_uppercase', 'maxlength'=>200, 'autocomplete' => 'off'],
                'required' => false,
                'translation_domain' => 'invoice',
            ])
        ;

        $newItem = new Destinatario();

        $builder->add('destinatarios', CollectionType::class, array(
            'entry_type' => DestinatarioType::class,
            'allow_add' => true,
            'allow_delete' => true,
            'prototype' => true,
            'by_reference' => false,
            'label' => false,
            'prototype_data' => $newItem,
        ));

        //$series =  $this->manager->getRepository('App\Entity\Model\Series')->findSeriesEmpresa($empresa->getId());

        $builder->add('series', EntityType::class, array(
            'class' => 'App\Entity\Model\Series',
            'choice_label' => 'value',
            'attr' => ['readonly'=>true, 'autocomplete' => 'off'],
            'required' => true,
            //'placeholder' => 'Seleccione una serie ...',
            'label' => 'form.series',
            'translation_domain' => 'invoice',
            'choices' => $series
        ));


        /*$builder->add('series', TextType::class, [
            'label' => 'form.series',
            'attr' => ['class'=>'sv_uppercase', 'maxlength'=>6,'readonly'=>true,'value'=>$series[0]->getValue()],
            'required' => true,
            'translation_domain' => 'invoice',
        ]);*/
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\AbstractGuiaRemision',
        ]);
    }
}
