<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * App\Entity\Model\Serie
 *
 * @ORM\Entity(repositoryClass="App\Repository\ItemRepository")
 * @ORM\Table()
 */
class Series
{
    /**
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id = null;

    /**
     *
     * @ORM\Column(name="name", type="string", length=255)
     * @Assert\NotBlank()
     */
    private  $name = null;

    /**
     * @ORM\Column(name="value", type="string", length=255, nullable=true)
     */
    private  $value = null;

    /**
     * @ORM\Column(name="ini_factura", type="integer")
     */
    private  $ini_factura = 1;

    /**
     * @ORM\Column(name="ini_credito", type="integer")
     */
    private  $ini_credito = 1;

    /**
     * @ORM\Column(name="ini_retencion", type="integer")
     */
    private  $ini_retencion = 1;

    /**
     * @ORM\Column(name="ini_guia", type="integer")
     */
    private  $ini_guia = 1;

    /**
     * @ORM\Column(name="ini_debito", type="integer")
     */
    private  $ini_debito = 1;

    /**
     * @ORM\Column(name="ini_liquidacion", type="integer")
     */
    private  $ini_liquidacion = 1;


    /**
     * @var boolean $enabled
     *
     * @ORM\Column(name="enabled", type="boolean")
     */
    private $enabled = 1;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Empresa")
     * @ORM\JoinColumn(name="empresa_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $empresa;

    public function __construct()
    {
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = strtoupper($name);
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set value
     *
     * @param string $value
     */
    public function setValue($value)
    {
        $this->value = strtoupper($value);
    }

    /**
     * Get value
     *
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return int
     */
    public function getIniFactura()
    {
        return $this->ini_factura;
    }

    /**
     * @param int $ini_factura
     */
    public function setIniFactura(int $ini_factura)
    {
        $this->ini_factura = $ini_factura;
    }

    /**
     * @return int
     */
    public function getIniCredito()
    {
        return $this->ini_credito;
    }

    /**
     * @param int $ini_credito
     */
    public function setIniCredito(int $ini_credito)
    {
        $this->ini_credito = $ini_credito;
    }

    /**
     * @return int
     */
    public function getIniRetencion()
    {
        return $this->ini_retencion;
    }

    /**
     * @param int $ini_retencion
     */
    public function setIniRetencion(int $ini_retencion)
    {
        $this->ini_retencion = $ini_retencion;
    }

    /**
     * @return int
     */
    public function getIniGuia()
    {
        return $this->ini_guia;
    }

    /**
     * @param int $ini_guia
     */
    public function setIniGuia(int $ini_guia)
    {
        $this->ini_guia = $ini_guia;
    }

    /**
     * @return int
     */
    public function getIniDebito()
    {
        return $this->ini_debito;
    }

    /**
     * @param int $ini_debito
     */
    public function setIniDebito(int $ini_debito)
    {
        $this->ini_debito = $ini_debito;
    }

    /**
     * @return int
     */
    public function getIniLiquidacion()
    {
        return $this->ini_liquidacion;
    }

    /**
     * @param int $ini_liquidacion
     */
    public function setIniLiquidacion(int $ini_liquidacion)
    {
        $this->ini_liquidacion = $ini_liquidacion;
    }

    /**
     * Set enabled
     *
     * @param boolean $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    /**
     * Get enabled
     *
     * @return boolean
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    public function __toString()
    {
        return $this->getName();
    }

    /**
     * @return mixed
     */
    public function getEmpresa()
    {
        return $this->empresa;
    }

    /**
     * @param mixed $empresa
     */
    public function setEmpresa($empresa)
    {
        $this->empresa = $empresa;
    }


}
