<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 * App\Entity\Model\Property
 *
 * @ORM\Table()
 * @ORM\Entity(repositoryClass="App\Repository\PropertyRepository")
 */
class Property
{
    /**
     * @var string $keey
     *
     * @ORM\Column(name="keey", type="string", length=50, unique=true)
     * @ORM\Id
     */
    private $key;

    /**
     * @var string $name
     *
     * @ORM\Column(type="string", length=50, nullable=false)
     */
    private $name;

    /**
     * @var text $value
     *
     * @ORM\Column(name="value", type="text")
     */
    private $value;

    public function __toString()
    {
        return $this->name;
    }

    /**
     * Set keey
     *
     * @param string $keey
     */
    public function setKey($keey)
    {
        $this->key = $keey;
    }

    /**
     * Get keey
     *
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return text
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param text $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

}
