<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 *
 * @ORM\Entity(repositoryClass="App\Repository\EmpresaRepository")
 */
class Empresa
{
    /**
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id = null;

    /**
     * @var date $issue_date
     *
     * @ORM\Column(name="create_date", type="date", nullable=true)
     * @Assert\Date()
     */
    private $create_date;

    /**
     * @ORM\Column(type="string", length=15, unique=true)
     * @Assert\NotNull()
     */
    private  $ruc;

    /**
     * @ORM\Column(name="razon_social", type="string", length=200)
     * @Assert\NotNull()
     */
    private  $razonSocial = null;

    /**
     * @ORM\Column(name="nombre_comercial", type="string", length=200, nullable=true)
     * @Assert\NotBlank(message="Please, upload an image first.")
     */
    private  $nombreComercial = null;

    /**
     * @ORM\Column(name="dir_establecimiento", type="string", length=200)
     * @Assert\NotNull()
     */
    private  $dirEstablecimiento = null;

    /**
     * @var string
     * @ORM\Column(type="string", length=5, nullable=true)
     */
    private $codEstablecimiento;

    /**
     * @ORM\Column(name="contribuyente_especial", type="string", length=5, nullable=true)
     */
    private  $contribuyenteEspecial = null;

    /**
     * @ORM\Column(name="lleva_contabilidad", type="boolean", nullable=true)
     */
    private  $llevaContabilidad = false;

    /**
     * @ORM\Column(name="genera_clave", type="boolean", nullable=true)
     */
    private  $generaClave;

    /**
     * @ORM\Column(name="tipo_ambiente", type="string", length=1)
     */
    private  $tipoAmbiente = "1";

    /**
     * @ORM\Column(name="direccion_matriz", type="string", length=200)
     * @Assert\NotNull()
     */
    private  $direccionMatriz = null;

    /**
     * @ORM\Column(name="ruta_firma", type="string", length=200, nullable=true)
     */
    private  $rutaFirma= null;

    /**
     * @ORM\Column(name="ruta_logo", type="string", length=200, nullable=true)
     */
    private  $rutaLogo = null;

    /**
     * @ORM\Column(name="pass_firma", type="string", length=200, nullable=true)
     */
    private  $passFirma = null;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private  $mail_host = null;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private  $mail_port = null;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private  $mailfrom = null;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private  $passmail = null;

    /**
     * @ORM\Column(type="string", length=5, nullable=true)
     */
    private  $mail_starttls = null;

    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
    private  $telefono = null;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private  $email = null;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private  $url = null;

    /**
     * @ORM\Column(type="string", length=5, nullable=true)
     */
    private  $currency = null;

    /**
     * @var date $fecha_cadfirma
     *
     * @ORM\Column(name="fecha_cadfirma", type="date", nullable=true)
     * @Assert\Date()
     */
    private $fechaCaducaFirma;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private  $envioAutomatico = false;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private  $rimpe = false;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private  $negpopular = false;

    /**
     * @ORM\Column(type="string", length=10, nullable=true)
     */
    private  $agente_ret = "";


    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Assert\Range(
     *      min = 0,
     *      max = 4,
     *      notInRangeMessage = "Valor debe fuera de rango min {{ min }} y max {{ max }}",
     * )
     */
    private  $dec_punit = 2;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private  $user_id;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private  $contratado;


    /**
     * @var boolean
     *
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $estransportista;

    /**
     * @ORM\OneToOne(targetEntity="App\Entity\Model\TransporteSocio")
     * @ORM\JoinColumn(name="transocio_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $transportesocio;

    /**
     * @var boolean
     *
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $enabled;

    /**
     * @var text
     * @ORM\Column(type="text", length=255, nullable=true)
     */
    private $mensaje;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Planes")
     * @ORM\JoinColumn(name="plan_id", referencedColumnName="id")
     */
    private $plan;

    /**
     * @var decimal $discount
     *
     * @ORM\Column(type="decimal", precision=15, scale=2)
     */
    private $costoplan;

    /**
     * @var date $fecha_inicio
     *
     * @ORM\Column(name="fecha_inicio", type="date", nullable=true)
     * @Assert\Date()
     */
    private $fecha_inicio;

    /**
     * @var date $fecha_caduca
     *
     * @ORM\Column(name="fecha_caduca", type="date", nullable=true)
     * @Assert\Date()
     */
    private $fecha_caduca;

    /**
     * @var boolean
     *
     * @ORM\Column(name="puedefacturar", type="boolean", nullable=true)
     */
    private $puedefacturar;

    /**
     * @var integer
     * @ORM\Column(name="cmp_contratados", type="integer", nullable=true)
     */
    private $cmp_contratados;

    /**
     * @var integer
     * @ORM\Column(name="cmp_emitidos", type="integer", nullable=true)
     */
    private $cmp_emitidos;


    /**
     * @var boolean
     *
     * @ORM\Column(name="habilitaprod", type="boolean", nullable=true)
     */
    private $habilitaprod;

    /**
     * @ORM\Column(name="envio_mail_automatico", type="boolean", nullable=true)
     */
    private  $envioMailAutomatico = false;

    /**
     * @ORM\Column(name="ruta_pago", type="string", length=200, nullable=true)
     */
    private  $rutaPago = null;

    /**
     * Empresa constructor.
     */
    public function __construct()
    {
        $this->create_date = new \DateTime();
        $this->puedefacturar = true;
        $this->costoplan =0;
        $this->cmp_contratados =0;
        $this->cmp_emitidos =0;
        $this->habilitaprod = false;
        $this->rimpe = false;
        $this->negpopular = false;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getRuc()
    {
        return $this->ruc;
    }

    /**
     * @param string $ruc
     */
    public function setRuc($ruc)
    {
        $this->ruc = $ruc;
    }

    /**
     * @return string
     */
    public function getRazonSocial()
    {
        return $this->razonSocial;
    }

    /**
     * @param string $razonSocial
     */
    public function setRazonSocial($razonSocial)
    {
        $this->razonSocial = strtoupper($razonSocial);
    }

    /**
     * @return string
     */
    public function getNombreComercial()
    {
        return $this->nombreComercial;
    }

    /**
     * @param string $nombreComercial
     */
    public function setNombreComercial($nombreComercial)
    {
        $this->nombreComercial = strtoupper($nombreComercial);
    }

    /**
     * @return string
     */
    public function getDirEstablecimiento()
    {
        return $this->dirEstablecimiento;
    }

    /**
     * @param string $dirEstablecimiento
     */
    public function setDirEstablecimiento($dirEstablecimiento)
    {
        $this->dirEstablecimiento = strtoupper($dirEstablecimiento);
    }

    /**
     * @return string
     */
    public function getContribuyenteEspecial()
    {
        return $this->contribuyenteEspecial;
    }

    /**
     * @param string $contribuyenteEspecial
     */
    public function setContribuyenteEspecial($contribuyenteEspecial)
    {
        $this->contribuyenteEspecial = $contribuyenteEspecial;
    }

    /**
     * @return bool
     */
    public function getLlevaContabilidad()
    {
        return $this->llevaContabilidad;
    }

    /**
     * @param bool $llevaContabilidad
     */
    public function setLlevaContabilidad($llevaContabilidad)
    {
        $this->llevaContabilidad = $llevaContabilidad;
    }

    /**
     * @return bool
     */
    public function getGeneraClave()
    {
        return $this->generaClave;
    }

    /**
     * @param bool $generaClave
     */
    public function setGeneraClave($generaClave)
    {
        $this->generaClave = $generaClave;
    }

    /**
     * @return string
     */
    public function getTipoAmbiente()
    {
        return $this->tipoAmbiente;
    }

    /**
     * @param string $tipoAmbiente
     */
    public function setTipoAmbiente($tipoAmbiente)
    {
        $this->tipoAmbiente = $tipoAmbiente;
    }

    /**
     * @return string
     */
    public function getDireccionMatriz()
    {
        return $this->direccionMatriz;
    }

    /**
     * @param string $direccionMatriz
     */
    public function setDireccionMatriz($direccionMatriz)
    {
        $this->direccionMatriz = strtoupper($direccionMatriz);
    }

    /**
     * @return string
     */
    public function getRutaFirma()
    {
        return $this->rutaFirma;
    }

    /**
     * @param string $rutaFirma
     */
    public function setRutaFirma($rutaFirma)
    {
        $this->rutaFirma = $rutaFirma;
    }

    /**
     * @return string
     */
    public function getPassFirma()
    {
        return $this->passFirma;
    }

    /**
     * @param string $passFirma
     */
    public function setPassFirma($passFirma)
    {
        $this->passFirma = $passFirma;
    }

    /**
     * @return string
     */
    public function getMailHost()
    {
        return $this->mail_host;
    }

    /**
     * @param string $mail_host
     */
    public function setMailHost($mail_host)
    {
        $this->mail_host = $mail_host;
    }

    /**
     * @return int
     */
    public function getMailPort()
    {
        return $this->mail_port;
    }

    /**
     * @param int $mail_port
     */
    public function setMailPort($mail_port)
    {
        $this->mail_port = $mail_port;
    }

    /**
     * @return string
     */
    public function getMailfrom()
    {
        return $this->mailfrom;
    }

    /**
     * @param string $mailfrom
     */
    public function setMailfrom($mailfrom)
    {
        $this->mailfrom = $mailfrom;
    }

    /**
     * @return string
     */
    public function getPassmail()
    {
        return $this->passmail;
    }

    /**
     * @param string $passmail
     */
    public function setPassmail($passmail)
    {
        $this->passmail = $passmail;
    }

    /**
     * @return string
     */
    public function getMailStarttls()
    {
        return $this->mail_starttls;
    }

    /**
     * @param string $mail_starttls
     */
    public function setMailStarttls($mail_starttls)
    {
        $this->mail_starttls = $mail_starttls;
    }

    /**
     * @return string
     */
    public function getRutaLogo()
    {
        return $this->rutaLogo === null ? "": $this->rutaLogo;
    }

    /**
     * @param string $rutaLogo
     */
    public function setRutaLogo($rutaLogo)
    {
        $this->rutaLogo = $rutaLogo;
    }

    /**
     * @return string
     */
    public function getTelefono()
    {
        return $this->telefono;
    }

    /**
     * @param string $telefono
     */
    public function setTelefono(string $telefono): void
    {
        $this->telefono = $telefono;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $url
     */
    public function setUrl(string $url): void
    {
        $this->url = $url;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     */
    public function setCurrency(string $currency): void
    {
        $this->currency = $currency;
    }

    /**
     * @return date
     */
    public function getFechaCaducaFirma()
    {
        return $this->fechaCaducaFirma;
    }

    /**
     * @param date $fechaCaducaFirma
     */
    public function setFechaCaducaFirma($fechaCaducaFirma)
    {
        $this->fechaCaducaFirma = $fechaCaducaFirma instanceof \DateTime ?
            $fechaCaducaFirma: new \DateTime($fechaCaducaFirma);
    }

    /**
     * @return bool
     */
    public function getEnvioAutomatico()
    {
        return $this->envioAutomatico;
    }

    /**
     * @param bool $envioAutomatico
     */
    public function setEnvioAutomatico($envioAutomatico): void
    {
        $this->envioAutomatico = $envioAutomatico;
    }

    /**
     * @return string
     */
    public function getAgenteRet()
    {
        return $this->agente_ret;
    }

    /**
     * @param string $agente_ret
     */
    public function setAgenteRet($agente_ret)
    {
        $this->agente_ret = $agente_ret;
    }

    /**
     * @return bool
     */
    public function getRimpe()
    {
        return $this->rimpe;
    }

    /**
     * @param bool $rimpe
     */
    public function setRimpe($rimpe)
    {
        $this->rimpe = $rimpe;
    }

    /**
     * @return date
     */
    public function getCreateDate()
    {
        return $this->create_date;
    }

    /**
     * @param date $create_date
     */
    public function setCreateDate($create_date)
    {
        $this->create_date = $create_date;
    }

    /**
     * @return int
     */
    public function getDecPunit()
    {
        return $this->dec_punit;
    }

    /**
     * @param int $dec_punit
     */
    public function setDecPunit(int $dec_punit)
    {
        $this->dec_punit = $dec_punit;
    }

    /**
     * @return int
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * @param int $user_id
     */
    public function setUserId($user_id): void
    {
        $this->user_id = $user_id;
    }

    /**
     * @return int
     */
    public function getContratado()
    {
        return $this->contratado ?? 0;
    }

    /**
     * @param int $contratado
     */
    public function setContratado($contratado)
    {
        $this->contratado = $contratado;
    }

    /**
     * @return bool
     */
    public function getEstransportista()
    {
        return $this->estransportista;
    }

    /**
     * @param bool $estransportista
     */
    public function setEstransportista($estransportista): void
    {
        $this->estransportista = $estransportista;
    }

    /**
     * @return mixed
     */
    public function getTransportesocio()
    {
        return $this->transportesocio;
    }

    /**
     * @param mixed $transportesocio
     */
    public function setTransportesocio($transportesocio): void
    {
        $this->transportesocio = $transportesocio;
    }

    /**
     * @return bool
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    /**
     * @return text
     */
    public function getMensaje()
    {
        return $this->mensaje;
    }

    /**
     * @param text $mensaje
     */
    public function setMensaje($mensaje)
    {
        $this->mensaje = $mensaje;
    }

    /**
     * @return mixed
     */
    public function getPlan()
    {
        return $this->plan;
    }

    /**
     * @param mixed $plan
     */
    public function setPlan($plan): void
    {
        $this->plan = $plan;
    }

    /**
     * @return decimal
     */
    public function getCostoplan()
    {
        return $this->costoplan;
    }

    /**
     * @param decimal $costoplan
     */
    public function setCostoplan($costoplan): void
    {
        $this->costoplan = $costoplan;
    }

    /**
     * @return date
     */
    public function getFechaInicio()
    {
        return $this->fecha_inicio;
    }

    /**
     * @param date $fecha_inicio
     */
    public function setFechaInicio($fecha_inicio): void
    {
        $this->fecha_inicio = $fecha_inicio;
    }

    /**
     * @return date
     */
    public function getFechaCaduca()
    {
        return $this->fecha_caduca;
    }

    /**
     * @param date $fecha_caduca
     */
    public function setFechaCaduca($fecha_caduca): void
    {
        $this->fecha_caduca = $fecha_caduca;
    }

    /**
     * @return bool
     */
    public function getPuedefacturar()
    {
        return $this->puedefacturar;
    }

    /**
     * @param bool $puedefacturar
     */
    public function setPuedefacturar($puedefacturar): void
    {
        $this->puedefacturar = $puedefacturar;
    }

    /**
     * @return int
     */
    public function getCmpContratados()
    {
        return $this->cmp_contratados;
    }

    /**
     * @param int $cmp_contratados
     */
    public function setCmpContratados($cmp_contratados): void
    {
        $this->cmp_contratados = $cmp_contratados;
    }

    /**
     * @return int
     */
    public function getCmpEmitidos()
    {
        return $this->cmp_emitidos;
    }

    /**
     * @param int $cmp_emitidos
     */
    public function setCmpEmitidos($cmp_emitidos): void
    {
        $this->cmp_emitidos = $cmp_emitidos;
    }

    /**
     * @return bool
     */
    public function getHabilitaprod()
    {
        return $this->habilitaprod;
    }

    /**
     * @param bool $habilitaprod
     */
    public function setHabilitaprod($habilitaprod): void
    {
        $this->habilitaprod = $habilitaprod;
    }

    /**
     * @return string
     */
    public function getCodEstablecimiento()
    {
        return $this->codEstablecimiento;
    }

    /**
     * @param string $codEstablecimiento
     */
    public function setCodEstablecimiento($codEstablecimiento): void
    {
        $this->codEstablecimiento = $codEstablecimiento;
    }

    /**
     * @return bool
     */
    public function getEnvioMailAutomatico()
    {
        return $this->envioMailAutomatico;
    }

    /**
     * @param bool $envioMailAutomatico
     */
    public function setEnvioMailAutomatico($envioMailAutomatico): void
    {
        $this->envioMailAutomatico = $envioMailAutomatico;
    }

    /**
     * @return null
     */
    public function getRutaPago()
    {
        return $this->rutaPago;
    }

    /**
     * @param null $rutaPago
     */
    public function setRutaPago($rutaPago)
    {
        $this->rutaPago = $rutaPago;
    }

    /**
     * @return bool
     */
    public function getNegpopular()
    {
        return $this->negpopular;
    }

    /**
     * @param bool $negpopular
     */
    public function setNegpopular($negpopular)
    {
        $this->negpopular = $negpopular;
    }

}
