<?php

namespace App\Controller;

use App\Entity\Model\User;
use App\Form\ChangePasswordFormType;
use App\Form\ResetPassFormType;
use App\Form\ResetPasswordRequestFormType;
use App\Service\EmFactory;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;

use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\Translation\TranslatorInterface;

class SecurityController extends AbstractController
{
    /**
     * @Route("/login", name="app_login")
     */
    public function login(AuthenticationUtils $authenticationUtils, ManagerRegistry $doctrine): Response
    {
        if ($this->isGranted("IS_AUTHENTICATED_FULLY")) {
            return $this->redirectToRoute("/");
        }

        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();
        // last username entered by the user
        $lastUsername = $authenticationUtils->getLastUsername();

        $logoportada = '/assets/static/images/bg3.jpg';
        try {
            $em = $doctrine->getManager('default');
            $repo = $em->getRepository('App\Entity\Model\Property');
            $path = $repo->getValue('logoportada');
            $logoportada = DIRECTORY_SEPARATOR . $path;
        } catch (\Exception $ex) {

        }

        return $this->render('security/login.html.twig', [
            'last_username' => $lastUsername,
            'error' => $error,
            'logoportada' => $logoportada
        ]);
    }

    /**
     * @Route("/logout", name="app_logout")
     */
    public function logout(): \Symfony\Component\HttpFoundation\Response
    {
        throw new \Exception('This method can be blank - it will be intercepted by the logout key on your firewall');
    }

    /**
     * @Route("/svycar/valemail", name="val_mail_pass")
     *
     */
    public function valMailPassAction(Request $request, ManagerRegistry $doctrine)
    {

        $form = $this->createForm(ResetPasswordRequestFormType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $doctrine->getManager('default');
            $repo = $em->getRepository(User::class);
            $user = $repo->findOneBy(['email' => $form->get('email')->getData()]);
            if ($user) {
                return $this->redirectToRoute('user_reset_password', ['mail' => base64_encode($user->getEmail())]);
            } else {
                $this->addFlash('reset_password_error', 'correo electrónico no existe');

            }

        }

        $logoportada = '/assets/static/images/bg3.jpg';
        try {
            $em = $doctrine->getManager('default');
            $repo = $em->getRepository('App\Entity\Model\Property');
            $path = $repo->getValue('logoportada');
            $logoportada = DIRECTORY_SEPARATOR . $path;
        } catch (\Exception $ex) {

        }

        return $this->render('security/request.html.twig', [
            'requestForm' => $form->createView(),
            'logoportada' => $logoportada
        ]);
    }

    /**
     * @Route("/svycar/reset_password/{mail}", name="user_reset_password")
     *
     */
    public function userResetPassAction($mail, ManagerRegistry $doctrine, Request $request, TranslatorInterface $translator, UserPasswordHasherInterface $passwordEncoder)
    {
        $this->translator = $translator;

        $em = $doctrine->getManager('default');
        $repo = $em->getRepository(User::class);
        $decodedMail = base64_decode($mail);
        $user = $repo->findOneBy(['email' => $decodedMail]);
        if (!$user) {
            throw $this->createNotFoundException('Unable to find User entity.');
        }

        // The token is valid; allow the user to change their password.
        $form = $this->createForm(ChangePasswordFormType::class, [
            'name' => $user->getRazonSocial(),
            'ruc' => $user->getRuc(),
        ]);

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            // codificar la contraseña simple
            $user->setPassword($passwordEncoder->hashPassword(
                $user,
                $form->get('plainPassword')->getData()
            ));

            $em->persist($user);
            $em->flush();

            // The session is cleaned up after the password has been changed.
            $this->cleanSessionAfterReset();

            return $this->redirectToRoute('app_login');
        }

        $logoportada = '/assets/static/images/bg3.jpg';
        try {
            $em = $doctrine->getManager('default');
            $repo = $em->getRepository('App\Entity\Model\Property');
            $path = $repo->getValue('logoportada');
            $logoportada = DIRECTORY_SEPARATOR . $path;
        } catch (\Exception $ex) {

        }

        return $this->render('security/reset.html.twig', [
            'resetForm' => $form->createView(),
            'logoportada' => $logoportada
        ]);
    }

    private function cleanSessionAfterReset(): void
    {
        $session = $this->getSessionService();

        $session->remove('ResetPasswordPublicToken');
        $session->remove('ResetPasswordCheckEmail');
        $session->remove('ResetPasswordToken');
    }

    private function getSessionService(): SessionInterface
    {
        /** @var Request $request */
        $request = $this->container->get('request_stack')->getCurrentRequest();

        return $request->getSession();
    }
}
