<?php

namespace App\Controller\Admin;

use App\Entity\Model\Customer;
use App\Entity\Model\Invoice;
use App\Entity\Model\Item;
use App\Entity\Model\ItemPago;
use App\Entity\Model\Planes;
use App\Service\EmFactory;
use App\Util\RestApiFunciones;
use Knp\Component\Pager\PaginatorInterface;
use Mobile_Detect;
use PDO;
use PDOException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Contracts\Translation\TranslatorInterface;

/**
 * @Route("/svadmin/config")
 */
class AdminPlanController extends AbstractController
{

    protected $translator;

    /**
     * @Route("", name="admin_plan_index")
     *
     */
    public function indexAction(EmFactory $emFactory, Request $request, PaginatorInterface $paginator, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $emisor = $empresaRepo->findAll();

        $repo = $em->getRepository('App\Entity\Model\Planes');
        $repo->setPaginator($paginator);
        $planes = $repo->findTodos();

        $limit = 50;

        $form = $this->createForm('App\Form\SearchPlanType', null, [
            'action' => $this->generateUrl('admin_plan_index'),
            'method' => 'GET',
        ]);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $pagination = $repo->paginatedSearch($form->getData(), $limit, $request->query->getInt('page', 1));
        } else {
            $pagination = $repo->paginatedSearch([], $limit, $request->query->getInt('page', 1));
        }

        return $this->render('Admin\Plan\index.html.twig',
            array(
                'planes' => $planes,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => 'USD',
                'search_form' => $form->createView(),
                //'list_form' => $listForm->createView(),
            ));
    }

    /**
     * @Route("/new", name="admin_plan_add")
     *
     */
    public function newAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $plan = new Planes();

        $form = $this->createForm('App\Form\PlanType', $plan, [
            'action' => $this->generateUrl('admin_plan_add'),
        ]);

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            if($plan->getIlimitado()) {
                $aux = $em->getRepository('App\Entity\Model\Planes')->findByIlimitado();

                if ($aux) {
                    $this->addTranslatedMessage('Ya existe un plan ilimitado registrado','danger');
                } else {
                    $em->persist($plan);
                    $em->flush();
                    $this->addTranslatedMessage('Plan Insertado');

                    return $this->redirect($this->generateUrl('admin_plan_index'));
                }
            }
            else {
                $em->persist($plan);
                $em->flush();
                $this->addTranslatedMessage('Plan Insertado');

                return $this->redirect($this->generateUrl('admin_plan_index'));
            }

        }
        return $this->render('Admin\Plan\edit.html.twig',
            array(
                'form' => $form->createView(),
                'entity' => $plan,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' =>  'USD',
            ));
    }


    /**
     * @Route("/edit/plan{id}", name="admin_plan_edit")
     *
     */
    public function editAction($id, EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $entity = $em->getRepository('App\Entity\Model\Planes')->findById($id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Plan entity.');
        }

        $form = $this->createForm('App\Form\PlanType', $entity, [
            'action' => $this->generateUrl('admin_plan_edit', array('id' => $id)),
        ]);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {

            if ($request->request->has('Form-delete')) {

                $em->remove($entity);
                $em->flush();
                $this->addTranslatedMessage('Plan eliminado');

                return $this->redirect($this->generateUrl('admin_plan_index'));
            }
            if ($form->isValid()) {
                $redirectRoute = 'admin_plan_edit';

                if($entity->getIlimitado()) {
                    $aux = $em->getRepository('App\Entity\Model\Planes')->findByIlimitadEdit($entity->getId());
                    if ($aux) {
                        $this->addTranslatedMessage('Ya existe un plan ilimitado registrado','danger');
                    } else {
                        $em->persist($entity);
                        $em->flush();
                        $this->addTranslatedMessage('Plan actualizado');

                        return $this->redirect($this->generateUrl($redirectRoute, array('id' => $id)));
                    }
                }
                else {

                    // Save.
                    $em->persist($entity);
                    $em->flush();
                    $this->addTranslatedMessage('Plan Actualizado');
                    return $this->redirect($this->generateUrl($redirectRoute, array('id' => $id)));
                }
            }
        }

        return $this->render('Admin\Plan\edit.html.twig',
            array(
                'entity' => $entity,
                'form' => $form->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' =>  'USD',
            ));
    }

    protected function addTranslatedMessage($message, $status = 'success')
    {
        $this->get('session')
            ->getFlashBag()
            ->add($status, $this->translator->trans($message, [], 'invoice'));
    }

}
